/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzq;
import com.google.android.gms.internal.zzsf;
import com.google.android.gms.internal.zzsg;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class zzqq<R extends Result>
extends PendingResult<R> {
    static final ThreadLocal<Boolean> yG = new ThreadLocal<Boolean>(){

        protected Boolean zzarw() {
            return false;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.zzarw();
        }
    };
    private final Object yH = new Object();
    protected final zza<R> yI;
    protected final WeakReference<GoogleApiClient> yJ;
    private final CountDownLatch zzank = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> yK = new ArrayList();
    private ResultCallback<? super R> yL;
    private final AtomicReference<zzsg.zzb> yM = new AtomicReference();
    private R xV;
    private zzb yN;
    private volatile boolean yO;
    private boolean zzak;
    private boolean yP;
    private zzq yQ;
    private volatile zzsf<R> yR;
    private boolean yS = false;

    @Deprecated
    zzqq() {
        this.yI = new zza(Looper.getMainLooper());
        this.yJ = new WeakReference<Object>(null);
    }

    protected zzqq(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.yI = new zza(looper);
        this.yJ = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzqq(Looper looper) {
        this.yI = new zza(looper);
        this.yJ = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzank.getCount() == 0L;
    }

    @Override
    public final R await() {
        zzaa.zza((Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread");
        zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed");
        zzaa.zza((this.yR == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            this.zzank.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzab(Status.ya);
        }
        zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long l, TimeUnit timeUnit) {
        zzaa.zza((l <= 0L || Looper.myLooper() != Looper.getMainLooper() ? 1 : 0) != 0, (Object)"await must not be called on the UI thread when time is greater than zero.");
        zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzaa.zza((this.yR == null ? 1 : 0) != 0, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzank.await(l, timeUnit);
            if (!bl) {
                this.zzab(Status.yc);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzab(Status.ya);
        }
        zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback) {
        Object object = this.yH;
        synchronized (object) {
            if (resultCallback == null) {
                this.yL = null;
                return;
            }
            zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((this.yR == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.yI.zza(resultCallback, (R)this.get());
            } else {
                this.yL = resultCallback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> resultCallback, long l, TimeUnit timeUnit) {
        Object object = this.yH;
        synchronized (object) {
            if (resultCallback == null) {
                this.yL = null;
                return;
            }
            zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((this.yR == null ? 1 : 0) != 0, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.isReady()) {
                this.yI.zza(resultCallback, (R)this.get());
            } else {
                this.yL = resultCallback;
                this.yI.zza(this, timeUnit.toMillis(l));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        zzaa.zzb((zza2 != null ? 1 : 0) != 0, (Object)"Callback cannot be null.");
        Object object = this.yH;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzx(this.xV.getStatus());
            } else {
                this.yK.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.yH;
        synchronized (object) {
            if (this.zzak || this.yO) {
                return;
            }
            if (this.yQ != null) {
                try {
                    this.yQ.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzqq.zze(this.xV);
            this.zzak = true;
            this.zzd(this.zzc(Status.yd));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zzars() {
        Object object = this.yH;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.yJ.get();
            if (googleApiClient == null || !this.yS) {
                this.cancel();
            }
            return this.isCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.yH;
        synchronized (object) {
            return this.zzak;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> resultTransform) {
        zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
        Object object = this.yH;
        synchronized (object) {
            zzaa.zza((this.yR == null ? 1 : 0) != 0, (Object)"Cannot call then() twice.");
            zzaa.zza((this.yL == null ? 1 : 0) != 0, (Object)"Cannot call then() if callbacks are set.");
            this.yS = true;
            this.yR = new zzsf(this.yJ);
            TransformedResult<? extends S> transformedResult = this.yR.then(resultTransform);
            if (this.isReady()) {
                this.yI.zza(this.yR, this.get());
            } else {
                this.yL = this.yR;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzc(R r) {
        Object object = this.yH;
        synchronized (object) {
            if (!this.yP && !this.zzak) {
                if (this.isReady()) {
                }
            } else {
                zzqq.zze(r);
                return;
            }
            zzaa.zza((!this.isReady() ? 1 : 0) != 0, (Object)"Results have already been set");
            zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed");
            this.zzd(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzab(Status status) {
        Object object = this.yH;
        synchronized (object) {
            if (!this.isReady()) {
                this.zzc(this.zzc(status));
                this.yP = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    private void zzart() {
        zzsg.zzb zzb2 = this.yM.getAndSet(null);
        if (zzb2 != null) {
            zzb2.zzc(this);
        }
    }

    public void zza(zzsg.zzb zzb2) {
        this.yM.set(zzb2);
    }

    public void zzaru() {
        this.setResultCallback(null);
    }

    @Override
    public Integer zzarh() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzq zzq2) {
        Object object = this.yH;
        synchronized (object) {
            this.yQ = zzq2;
        }
    }

    public void zzarv() {
        this.yS = this.yS || yG.get() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.yH;
        synchronized (object) {
            zzaa.zza((!this.yO ? 1 : 0) != 0, (Object)"Result has already been consumed.");
            zzaa.zza((boolean)this.isReady(), (Object)"Result is not ready.");
            r = this.xV;
            this.xV = null;
            this.yL = null;
            this.yO = true;
        }
        this.zzart();
        return r;
    }

    private void zzd(R r) {
        this.xV = r;
        this.yQ = null;
        this.zzank.countDown();
        Status status = this.xV.getStatus();
        if (this.zzak) {
            this.yL = null;
        } else if (this.yL == null) {
            if (this.xV instanceof Releasable) {
                this.yN = new zzb();
            }
        } else {
            this.yI.zzarx();
            this.yI.zza(this.yL, (R)this.get());
        }
        for (PendingResult.zza zza2 : this.yK) {
            zza2.zzx(status);
        }
        this.yK.clear();
    }

    public static void zze(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)result).release();
            }
            catch (RuntimeException runtimeException) {
                String string2 = String.valueOf(result);
                Log.w((String)"BasePendingResult", (String)new StringBuilder(18 + String.valueOf(string2).length()).append("Unable to release ").append(string2).toString(), (Throwable)runtimeException);
            }
        }
    }

    private final class zzb {
        private zzb() {
        }

        protected void finalize() throws Throwable {
            zzqq.zze(zzqq.this.xV);
            super.finalize();
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzqq<R> zzqq2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzqq2), l);
        }

        public void zzarx() {
            this.removeMessages(2);
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    Pair pair = (Pair)message.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzqq zzqq2 = (zzqq)message.obj;
                    zzqq2.zzab(Status.yc);
                    return;
                }
            }
            int n = message.what;
            Log.wtf((String)"BasePendingResult", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzqq.zze(r);
                throw runtimeException;
            }
        }
    }
}

