/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzb;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzql;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqr;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzrh;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzsa;
import com.google.android.gms.internal.zzsv;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

public class zzqu
implements zzrm {
    private final Map<Api.zzc<?>, com.google.android.gms.common.api.zzc<?>> zj = new HashMap();
    private final Map<Api<?>, Integer> zk;
    private final zzrh xy;
    private final zzrd zl;
    private final Lock zg;
    private final Looper zzajy;
    private final zzc zm;
    private final Condition zn;
    private boolean zo;
    private Map<zzql<?>, ConnectionResult> zp;
    private ConnectionResult zq;

    public zzqu(Context context, Lock lock, Looper looper, zzc zzc2, Map<Api.zzc<?>, Api.zze> map, Map<Api<?>, Integer> map2, ArrayList<zzqr> arrayList, zzrd zzrd2) {
        this.zg = lock;
        this.zzajy = looper;
        this.zn = lock.newCondition();
        this.zm = zzc2;
        this.zl = zzrd2;
        this.zk = map2;
        HashMap hashMap = new HashMap();
        for (Api<?> iterator : map2.keySet()) {
            hashMap.put(iterator.zzaqv(), iterator);
        }
        HashMap hashMap2 = new HashMap();
        for (zzqr zzqr2 : arrayList) {
            hashMap2.put(zzqr2.vS, zzqr2);
        }
        for (Map.Entry<Api.zzc<?>, Api.zze> entry : map.entrySet()) {
            Api api = (Api)hashMap.get(entry.getKey());
            Api.zze zze2 = entry.getValue();
            zzqr zzqr3 = (zzqr)hashMap2.get(api);
            com.google.android.gms.common.api.zzc zzc3 = new com.google.android.gms.common.api.zzc(context, api, looper, zze2, zzqr3){};
            this.zj.put(entry.getKey(), zzc3);
        }
        this.xy = zzrh.zzatg();
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(@NonNull T t) {
        this.zl.Ap.zzb(t);
        return this.zj.get(t.zzaqv()).doRead(t);
    }

    @Override
    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(@NonNull T t) {
        this.zl.Ap.zzb(t);
        return this.zj.get(t.zzaqv()).doWrite(t);
    }

    @Override
    public void connect() {
        this.zg.lock();
        try {
            if (this.zo) {
                return;
            }
            this.zo = true;
            this.zp = null;
            this.zq = null;
            zza zza2 = new zza();
            zzsv zzsv2 = new zzsv(this.zzajy);
            this.xy.zza(this.zj.values()).addOnSuccessListener((Executor)zzsv2, (OnSuccessListener)zza2).addOnFailureListener((Executor)zzsv2, (OnFailureListener)zza2);
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public ConnectionResult blockingConnect() {
        this.connect();
        while (this.isConnecting()) {
            try {
                this.zn.await();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.wO;
        }
        if (this.zq != null) {
            return this.zq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public ConnectionResult blockingConnect(long l, TimeUnit timeUnit) {
        this.connect();
        long l2 = timeUnit.toNanos(l);
        while (this.isConnecting()) {
            try {
                if (l2 <= 0L) {
                    this.disconnect();
                    return new ConnectionResult(14, null);
                }
                l2 = this.zn.awaitNanos(l2);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                return new ConnectionResult(15, null);
            }
        }
        if (this.isConnected()) {
            return ConnectionResult.wO;
        }
        if (this.zq != null) {
            return this.zq;
        }
        return new ConnectionResult(13, null);
    }

    @Override
    public void disconnect() {
        this.zg.lock();
        try {
            this.zo = false;
            this.zp = null;
            this.zq = null;
            this.zn.signalAll();
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    @Nullable
    public ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        this.zg.lock();
        try {
            if (this.zj.get(api.zzaqv()).getClient().isConnected()) {
                ConnectionResult connectionResult = ConnectionResult.wO;
                return connectionResult;
            }
            if (this.zp != null) {
                ConnectionResult connectionResult = this.zp.get(this.zj.get(api.zzaqv()).getApiKey());
                return connectionResult;
            }
            Object var2_4 = null;
            return null;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.zg.lock();
        try {
            boolean bl = this.zp != null && this.zq == null;
            return bl;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public boolean isConnecting() {
        this.zg.lock();
        try {
            boolean bl = this.zp == null && this.zo;
            return bl;
        }
        finally {
            this.zg.unlock();
        }
    }

    @Override
    public boolean zza(zzsa zzsa2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void zzard() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
    }

    @Override
    public void zzarz() {
    }

    private class zza
    implements OnFailureListener,
    OnSuccessListener<Void> {
        private zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zza(Void void_) {
            zzqu.this.zg.lock();
            try {
                zzqu.this.zp = (Map)new ArrayMap(zzqu.this.zj.size());
                for (Api.zzc zzc2 : zzqu.this.zj.keySet()) {
                    zzqu.this.zp.put(((com.google.android.gms.common.api.zzc)zzqu.this.zj.get(zzc2)).getApiKey(), ConnectionResult.wO);
                }
                zzqu.this.zl.zzn(null);
                zzqu.this.zn.signalAll();
            }
            finally {
                zzqu.this.zg.unlock();
            }
        }

        public void onFailure(@NonNull Exception exception) {
            zzb zzb2 = (zzb)exception;
            zzqu.this.zg.lock();
            try {
                zzqu.this.zp = zzb2.zzara();
                zzqu.this.zq = this.zzash();
                if (zzqu.this.zq == null) {
                    zzqu.this.zl.zzn(null);
                } else {
                    zzqu.this.zo = false;
                    zzqu.this.zl.zzc(zzqu.this.zq);
                }
                zzqu.this.zn.signalAll();
            }
            finally {
                zzqu.this.zg.unlock();
            }
        }

        @Nullable
        private ConnectionResult zzash() {
            ConnectionResult connectionResult = null;
            int n = 0;
            for (Api api : zzqu.this.zk.keySet()) {
                int n2;
                ConnectionResult connectionResult2 = (ConnectionResult)zzqu.this.zp.get(((com.google.android.gms.common.api.zzc)zzqu.this.zj.get(api.zzaqv())).getApiKey());
                if (connectionResult2.isSuccess() || (n2 = ((Integer)zzqu.this.zk.get(api)).intValue()) == 2 || n2 == 1 && !connectionResult2.hasResolution() && !zzqu.this.zm.isUserResolvableError(connectionResult2.getErrorCode())) continue;
                int n3 = api.zzaqs().getPriority();
                if (connectionResult != null && n <= n3) continue;
                connectionResult = connectionResult2;
                n = n3;
            }
            return connectionResult;
        }

        public /* synthetic */ void onSuccess(Object object) {
            this.zza((Void)object);
        }
    }
}

