/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.BinderThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzre;
import com.google.android.gms.internal.zzrf;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzxp;
import com.google.android.gms.internal.zzxq;
import com.google.android.gms.signin.internal.SignInResponse;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzrb
implements zzre {
    private final zzrf zA;
    private final Lock zg;
    private final Context mContext;
    private final com.google.android.gms.common.zzc zm;
    private ConnectionResult zq;
    private int zD;
    private int zE = 0;
    private int zF;
    private final Bundle zG = new Bundle();
    private final Set<Api.zzc> zH = new HashSet<Api.zzc>();
    private zzxp zI;
    private int zJ;
    private boolean zK;
    private boolean zL;
    private zzp zM;
    private boolean zN;
    private boolean zO;
    private final com.google.android.gms.common.internal.zzf zP;
    private final Map<Api<?>, Integer> zk;
    private final Api.zza<? extends zzxp, zzxq> xQ;
    private ArrayList<Future<?>> zQ = new ArrayList();

    public zzrb(zzrf zzrf2, com.google.android.gms.common.internal.zzf zzf2, Map<Api<?>, Integer> map, com.google.android.gms.common.zzc zzc2, Api.zza<? extends zzxp, zzxq> zza2, Lock lock, Context context) {
        this.zA = zzrf2;
        this.zP = zzf2;
        this.zk = map;
        this.zm = zzc2;
        this.xQ = zza2;
        this.zg = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zA.Ay.clear();
        this.zK = false;
        this.zq = null;
        this.zE = 0;
        this.zJ = 2;
        this.zL = false;
        this.zN = false;
        boolean bl = false;
        HashMap<Api.zze, zza> hashMap = new HashMap<Api.zze, zza>();
        for (Api<?> api : this.zk.keySet()) {
            Api.zze zze2 = this.zA.Aj.get(api.zzaqv());
            int n = this.zk.get(api);
            bl |= api.zzaqs().getPriority() == 1;
            if (zze2.zzain()) {
                this.zK = true;
                if (n < this.zJ) {
                    this.zJ = n;
                }
                if (n != 0) {
                    this.zH.add(api.zzaqv());
                }
            }
            hashMap.put(zze2, new zza(this, api, n));
        }
        if (bl) {
            this.zK = false;
        }
        if (this.zK) {
            this.zP.zzc(this.zA.yW.getSessionId());
            zze zze3 = new zze();
            this.zI = this.xQ.zza(this.mContext, this.zA.yW.getLooper(), this.zP, this.zP.zzavv(), zze3, zze3);
        }
        this.zF = this.zA.Aj.size();
        this.zQ.add(zzrg.zzatf().submit(new zzb(hashMap)));
    }

    private boolean zzasp() {
        --this.zF;
        if (this.zF > 0) {
            return false;
        }
        if (this.zF < 0) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zA.yW.zzatb());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        if (this.zq != null) {
            this.zA.AB = this.zD;
            this.zzf(this.zq);
            return false;
        }
        return true;
    }

    private void zza(SignInResponse signInResponse) {
        if (!this.zzft(0)) {
            return;
        }
        ConnectionResult connectionResult = signInResponse.zzawn();
        if (connectionResult.isSuccess()) {
            ResolveAccountResponse resolveAccountResponse = signInResponse.zzcdn();
            ConnectionResult connectionResult2 = resolveAccountResponse.zzawn();
            if (!connectionResult2.isSuccess()) {
                String string2 = String.valueOf(connectionResult2);
                Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(48 + String.valueOf(string2).length()).append("Sign-in succeeded with resolve account failure: ").append(string2).toString(), (Throwable)new Exception());
                this.zzf(connectionResult2);
                return;
            }
            this.zL = true;
            this.zM = resolveAccountResponse.zzawm();
            this.zN = resolveAccountResponse.zzawo();
            this.zO = resolveAccountResponse.zzawp();
            this.zzasq();
        } else if (this.zze(connectionResult)) {
            this.zzast();
            this.zzasq();
        } else {
            this.zzf(connectionResult);
        }
    }

    private void zzasq() {
        if (this.zF != 0) {
            return;
        }
        if (!this.zK || this.zL) {
            this.zzasr();
        }
    }

    private void zzasr() {
        ArrayList<Api.zze> arrayList = new ArrayList<Api.zze>();
        this.zE = 1;
        this.zF = this.zA.Aj.size();
        for (Api.zzc<?> zzc2 : this.zA.Aj.keySet()) {
            if (this.zA.Ay.containsKey(zzc2)) {
                if (!this.zzasp()) continue;
                this.zzass();
                continue;
            }
            arrayList.add(this.zA.Aj.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zQ.add(zzrg.zzatf().submit(new zzc(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle bundle) {
        if (!this.zzft(1)) {
            return;
        }
        if (bundle != null) {
            this.zG.putAll(bundle);
        }
        if (this.zzasp()) {
            this.zzass();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzft(1)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzasp()) {
            this.zzass();
        }
    }

    private void zzass() {
        this.zA.zzatd();
        zzrg.zzatf().execute(new Runnable(){

            @Override
            public void run() {
                zzrb.this.zm.zzbn(zzrb.this.mContext);
            }
        });
        if (this.zI != null) {
            if (this.zN) {
                this.zI.zza(this.zM, this.zO);
            }
            this.zzbr(false);
        }
        for (Api.zzc<?> zzc2 : this.zA.Ay.keySet()) {
            Api.zze zze2 = this.zA.Aj.get(zzc2);
            zze2.disconnect();
        }
        Bundle bundle = this.zG.isEmpty() ? null : this.zG;
        this.zA.AC.zzn(bundle);
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzqo.zza<R, A>> T zza(T t) {
        this.zA.yW.Ad.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzqo.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
    }

    @Override
    public boolean disconnect() {
        this.zzasu();
        this.zzbr(true);
        this.zA.zzh(null);
        return true;
    }

    @Override
    public void onConnectionSuspended(int n) {
        this.zzf(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzaqs().getPriority(), n, connectionResult)) {
            this.zq = connectionResult;
            this.zD = n2;
        }
        this.zA.Ay.put(api.zzaqv(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zzd(connectionResult)) {
            return false;
        }
        return this.zq == null || n < this.zD;
    }

    private boolean zzd(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zm.zzfp(connectionResult.getErrorCode()) != null;
    }

    private void zzast() {
        this.zK = false;
        this.zA.yW.Ak = Collections.emptySet();
        for (Api.zzc zzc2 : this.zH) {
            if (this.zA.Ay.containsKey(zzc2)) continue;
            this.zA.Ay.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zze(ConnectionResult connectionResult) {
        return this.zJ == 2 || this.zJ == 1 && !connectionResult.hasResolution();
    }

    private void zzf(ConnectionResult connectionResult) {
        this.zzasu();
        this.zzbr(!connectionResult.hasResolution());
        this.zA.zzh(connectionResult);
        this.zA.AC.zzc(connectionResult);
    }

    private void zzbr(boolean bl) {
        if (this.zI != null) {
            if (this.zI.isConnected() && bl) {
                this.zI.zzcdc();
            }
            this.zI.disconnect();
            this.zM = null;
        }
    }

    private void zzasu() {
        for (Future<?> future : this.zQ) {
            future.cancel(true);
        }
        this.zQ.clear();
    }

    private Set<Scope> zzasv() {
        if (this.zP == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zP.zzavp());
        Map<Api<?>, zzf.zza> map = this.zP.zzavr();
        for (Api<?> api : map.keySet()) {
            if (this.zA.Ay.containsKey(api.zzaqv())) continue;
            hashSet.addAll(map.get(api).jw);
        }
        return hashSet;
    }

    private boolean zzft(int n) {
        if (this.zE != n) {
            Log.w((String)"GoogleApiClientConnecting", (String)this.zA.yW.zzatb());
            String string2 = String.valueOf(this);
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(23 + String.valueOf(string2).length()).append("Unexpected callback in ").append(string2).toString());
            int n2 = this.zF;
            Log.w((String)"GoogleApiClientConnecting", (String)new StringBuilder(33).append("mRemainingConnections=").append(n2).toString());
            String string3 = String.valueOf(this.zzfu(this.zE));
            String string4 = String.valueOf(this.zzfu(n));
            Log.wtf((String)"GoogleApiClientConnecting", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string4).length()).append("GoogleApiClient connecting is in step ").append(string3).append(" but received callback for step ").append(string4).toString(), (Throwable)new Exception());
            this.zzf(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzfu(int n) {
        switch (n) {
            case 0: {
                return "STEP_SERVICE_BINDINGS_AND_SIGN_IN";
            }
            case 1: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zzd
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzrb> zS;

        zzd(zzrb zzrb2) {
            this.zS = new WeakReference<zzrb>(zzrb2);
        }

        @Override
        @BinderThread
        public void zzb(final SignInResponse signInResponse) {
            final zzrb zzrb2 = (zzrb)this.zS.get();
            if (zzrb2 == null) {
                return;
            }
            zzrb2.zA.zza(new zzrf.zza(zzrb2){

                @Override
                public void zzaso() {
                    zzrb2.zza(signInResponse);
                }
            });
        }
    }

    private static class zza
    implements zze.zzf {
        private final WeakReference<zzrb> zS;
        private final Api<?> vS;
        private final int yU;

        public zza(zzrb zzrb2, Api<?> api, int n) {
            this.zS = new WeakReference<zzrb>(zzrb2);
            this.vS = api;
            this.yU = n;
        }

        public void zzg(@NonNull ConnectionResult connectionResult) {
            zzrb zzrb2 = (zzrb)this.zS.get();
            if (zzrb2 == null) {
                return;
            }
            zzaa.zza((Looper.myLooper() == ((zzrb)zzrb2).zA.yW.getLooper() ? 1 : 0) != 0, (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzrb2.zg.lock();
            try {
                if (!zzrb2.zzft(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzrb2.zzb(connectionResult, this.vS, this.yU);
                }
                if (zzrb2.zzasp()) {
                    zzrb2.zzasq();
                }
            }
            finally {
                zzrb2.zg.unlock();
            }
        }
    }

    private class zze
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zze() {
        }

        @Override
        public void onConnected(Bundle bundle) {
            zzrb.this.zI.zza(new zzd(zzrb.this));
        }

        @Override
        public void onConnectionSuspended(int n) {
        }

        @Override
        public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            zzrb.this.zg.lock();
            try {
                if (zzrb.this.zze(connectionResult)) {
                    zzrb.this.zzast();
                    zzrb.this.zzasq();
                } else {
                    zzrb.this.zzf(connectionResult);
                }
            }
            finally {
                zzrb.this.zg.unlock();
            }
        }
    }

    private class zzc
    extends zzf {
        private final ArrayList<Api.zze> zX;

        public zzc(ArrayList<Api.zze> arrayList) {
            this.zX = arrayList;
        }

        @Override
        @WorkerThread
        public void zzaso() {
            ((zzrb)zzrb.this).zA.yW.Ak = zzrb.this.zzasv();
            for (Api.zze zze2 : this.zX) {
                zze2.zza(zzrb.this.zM, ((zzrb)zzrb.this).zA.yW.Ak);
            }
        }
    }

    private class zzb
    extends zzf {
        private final Map<Api.zze, zza> zT;

        public zzb(Map<Api.zze, zza> map) {
            this.zT = map;
        }

        @Override
        @WorkerThread
        public void zzaso() {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            for (Api.zze object : this.zT.keySet()) {
                if (object.zzaqx()) {
                    bl2 = true;
                    if (this.zT.get(object).yU != 0) continue;
                    bl = true;
                    break;
                }
                bl3 = false;
            }
            int n2 = n = bl2 ? zzrb.this.zm.isGooglePlayServicesAvailable(zzrb.this.mContext) : 0;
            if (n != 0 && (bl || bl3)) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzrb.this.zA.zza(new zzrf.zza(zzrb.this){

                    @Override
                    public void zzaso() {
                        zzrb.this.zzf(connectionResult);
                    }
                });
                return;
            }
            if (zzrb.this.zK) {
                zzrb.this.zI.connect();
            }
            for (Api.zze zze2 : this.zT.keySet()) {
                final zze.zzf zzf2 = this.zT.get(zze2);
                if (zze2.zzaqx() && n != 0) {
                    zzrb.this.zA.zza(new zzrf.zza(zzrb.this){

                        @Override
                        public void zzaso() {
                            zzf2.zzg(new ConnectionResult(16, null));
                        }
                    });
                    continue;
                }
                zze2.zza(zzf2);
            }
        }
    }

    private abstract class zzf
    implements Runnable {
        private zzf() {
        }

        @Override
        @WorkerThread
        public void run() {
            zzrb.this.zg.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzaso();
            }
            catch (RuntimeException runtimeException) {
                zzrb.this.zA.zza(runtimeException);
            }
            finally {
                zzrb.this.zg.unlock();
            }
        }

        @WorkerThread
        protected abstract void zzaso();
    }
}

