/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaax;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

@TargetApi(value=11)
public final class zzaay
extends Fragment
implements zzaax {
    private static WeakHashMap<Activity, WeakReference<zzaay>> zzaBt = new WeakHashMap();
    private Map<String, zzaaw> zzaBu = new ArrayMap();
    private int zzJh = 0;
    private Bundle zzaBv;

    public static zzaay zzt(Activity activity) {
        zzaay zzaay2;
        WeakReference<zzaay> weakReference = zzaBt.get(activity);
        if (weakReference != null && (zzaay2 = (zzaay)weakReference.get()) != null) {
            return zzaay2;
        }
        try {
            zzaay2 = (zzaay)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzaay2 == null || zzaay2.isRemoving()) {
            zzaay2 = new zzaay();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzaay2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzaBt.put(activity, new WeakReference<zzaay>(zzaay2));
        return zzaay2;
    }

    @Override
    public <T extends zzaaw> T zza(String string2, Class<T> clazz) {
        return (T)((zzaaw)clazz.cast(this.zzaBu.get(string2)));
    }

    @Override
    public void zza(String string2, @NonNull zzaaw zzaaw2) {
        if (this.zzaBu.containsKey(string2)) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
        }
        this.zzaBu.put(string2, zzaaw2);
        this.zzb(string2, zzaaw2);
    }

    private void zzb(final String string2, final @NonNull zzaaw zzaaw2) {
        if (this.zzJh > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (zzaay.this.zzJh >= 1) {
                        zzaaw2.onCreate(zzaay.this.zzaBv != null ? zzaay.this.zzaBv.getBundle(string2) : null);
                    }
                    if (zzaay.this.zzJh >= 2) {
                        zzaaw2.onStart();
                    }
                    if (zzaay.this.zzJh >= 3) {
                        zzaaw2.onStop();
                    }
                    if (zzaay.this.zzJh >= 4) {
                        zzaaw2.onDestroy();
                    }
                }
            });
        }
    }

    @Override
    public Activity zzwo() {
        return this.getActivity();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzJh = 1;
        this.zzaBv = bundle;
        for (Map.Entry<String, zzaaw> entry : this.zzaBu.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public void onStart() {
        super.onStart();
        this.zzJh = 2;
        for (zzaaw zzaaw2 : this.zzaBu.values()) {
            zzaaw2.onStart();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        for (zzaaw zzaaw2 : this.zzaBu.values()) {
            zzaaw2.onActivityResult(n, n2, intent);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, zzaaw> entry : this.zzaBu.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public void onStop() {
        super.onStop();
        this.zzJh = 3;
        for (zzaaw zzaaw2 : this.zzaBu.values()) {
            zzaaw2.onStop();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.zzJh = 4;
        for (zzaaw zzaaw2 : this.zzaBu.values()) {
            zzaaw2.onDestroy();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        for (zzaaw zzaaw2 : this.zzaBu.values()) {
            zzaaw2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }
}

