/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.zzc;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.zzcn;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class AdvertisingIdClient {
    com.google.android.gms.common.zza zzse;
    zzcn zzsf;
    boolean zzsg;
    Object zzsh = new Object();
    zza zzsi;
    private final Context mContext;
    final long zzsj;

    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false);
    }

    public AdvertisingIdClient(Context context, long l, boolean bl) {
        Context context2;
        zzac.zzw(context);
        this.mContext = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzsg = false;
        this.zzsj = l;
    }

    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zze(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zze(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzac.zzdo("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzsg) {
                this.finish();
            }
            this.zzse = AdvertisingIdClient.zzf(this.mContext);
            this.zzsf = AdvertisingIdClient.zza(this.mContext, this.zzse);
            this.zzsg = true;
            if (bl) {
                this.zzbx();
            }
        }
    }

    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzbx() {
        Object object = this.zzsh;
        synchronized (object) {
            if (this.zzsi != null) {
                this.zzsi.cancel();
                try {
                    this.zzsi.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzsj > 0L) {
                this.zzsi = new zza(this, this.zzsj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Info getInfo() throws IOException {
        Info info;
        zzac.zzdo("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzsg) {
                Object object = this.zzsh;
                synchronized (object) {
                    if (this.zzsi == null || !this.zzsi.zzby()) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zze(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzsg) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzac.zzw(this.zzse);
            zzac.zzw(this.zzsf);
            try {
                info = new Info(this.zzsf.getId(), this.zzsf.zzf(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zzbx();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        zzac.zzdo("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.mContext == null || this.zzse == null) {
                return;
            }
            try {
                if (this.zzsg) {
                    com.google.android.gms.common.stats.zza.zzyc().zza(this.mContext, this.zzse);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)illegalArgumentException);
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzsg = false;
            this.zzsf = null;
            this.zzse = null;
        }
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    static com.google.android.gms.common.zza zzf(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            PackageManager packageManager = context.getPackageManager();
            packageManager.getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        int n = zzc.zzuz().isGooglePlayServicesAvailable(context);
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zzyc().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        Object object;
        boolean bl = false;
        float f = 0.0f;
        try {
            object = zze.getRemoteContext(context);
            if (object != null) {
                SharedPreferences sharedPreferences = object.getSharedPreferences("google_ads_flags", 1);
                bl = sharedPreferences.getBoolean("gads:ad_id_app_context:enabled", false);
                f = sharedPreferences.getFloat("gads:ad_id_app_context:ping_ratio", 0.0f);
            }
        }
        catch (Exception exception) {
            Log.w((String)"AdvertisingIdClient", (String)"Error while reading from SharedPreferences ", (Throwable)exception);
        }
        object = new AdvertisingIdClient(context, -1L, bl);
        try {
            ((AdvertisingIdClient)object).zze(false);
            Info info = ((AdvertisingIdClient)object).getInfo();
            super.zza(info, bl, f, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            super.zza(null, bl, f, throwable);
            return null;
        }
        finally {
            ((AdvertisingIdClient)object).finish();
        }
    }

    private void zza(Info info, boolean bl, float f, Throwable throwable) {
        if (Math.random() > (double)f) {
            return;
        }
        Uri uri = this.zza(info, bl, throwable);
        final String string2 = uri.toString();
        new Thread(this){

            @Override
            public void run() {
                new com.google.android.gms.ads.identifier.zza().zzu(string2);
            }
        }.start();
    }

    Uri zza(Info info, boolean bl, Throwable throwable) {
        Bundle bundle = new Bundle();
        bundle.putString("app_context", bl ? "1" : "0");
        if (info != null) {
            bundle.putString("limit_ad_tracking", info.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info != null && info.getId() != null) {
            bundle.putString("ad_id_size", Integer.toString(info.getId().length()));
        }
        if (throwable != null) {
            bundle.putString("error", throwable.getClass().getName());
        }
        Uri.Builder builder = Uri.parse((String)"https://pagead2.googlesyndication.com/pagead/gen_204?id=gmob-apps").buildUpon();
        for (String string2 : bundle.keySet()) {
            builder.appendQueryParameter(string2, bundle.getString(string2));
        }
        return builder.build();
    }

    static zzcn zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzcn.zza.zzf(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zzsp;
        private final boolean zzsq;

        public Info(String string, boolean bl) {
            this.zzsp = string;
            this.zzsq = bl;
        }

        public String getId() {
            return this.zzsp;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.zzsq;
        }

        public String toString() {
            String string = this.zzsp;
            boolean bl = this.zzsq;
            return new StringBuilder(7 + String.valueOf(string).length()).append("{").append(string).append("}").append(bl).toString();
        }
    }

    static class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzsl;
        private long zzsm;
        CountDownLatch zzsn;
        boolean zzso;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzsl = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzsm = l;
            this.zzsn = new CountDownLatch(1);
            this.zzso = false;
            this.start();
        }

        public void cancel() {
            this.zzsn.countDown();
        }

        public boolean zzby() {
            return this.zzso;
        }

        private void disconnect() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzsl.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzso = true;
            }
        }

        @Override
        public void run() {
            try {
                if (!this.zzsn.await(this.zzsm, TimeUnit.MILLISECONDS)) {
                    this.disconnect();
                }
            }
            catch (InterruptedException interruptedException) {
                this.disconnect();
            }
        }
    }
}

