/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.internal.zzaa;

public final class Status
extends zza
implements Result,
ReflectedParcelable {
    public static final Status zzazx = new Status(0);
    public static final Status zzazy = new Status(14);
    public static final Status zzazz = new Status(8);
    public static final Status zzazA = new Status(15);
    public static final Status zzazB = new Status(16);
    public static final Status zzazC = new Status(17);
    public static final Status zzazD = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzh();
    final int zzaiI;
    private final int zzavD;
    private final String zzayk;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.zzaiI = n;
        this.zzavD = n2;
        this.zzayk = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzvu() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.zzayk;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzavD <= 0;
    }

    public boolean isCanceled() {
        return this.zzavD == 16;
    }

    public boolean isInterrupted() {
        return this.zzavD == 14;
    }

    public int getStatusCode() {
        return this.zzavD;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzaa.hashCode(this.zzaiI, this.zzavD, this.zzayk, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzaiI == status.zzaiI && this.zzavD == status.zzavD && zzaa.equal(this.zzayk, status.zzayk) && zzaa.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public String zzvv() {
        if (this.zzayk != null) {
            return this.zzayk;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzavD);
    }

    public String toString() {
        return zzaa.zzv(this).zzg("statusCode", this.zzvv()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

