/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.zze;
import com.google.android.gms.common.zzo;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    private static final zze zzbCG = zze.zzoW();
    private static final Object zzuH = new Object();
    private static Method zzbCH = null;
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installIfNeeded(Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        zzbo.zzb(context, (Object)"Context must not be null");
        zze.zzas(context);
        Context context2 = zzo.getRemoteContext(context);
        if (context2 == null) {
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
        Object object = zzuH;
        synchronized (object) {
            try {
                if (zzbCH == null) {
                    Class<?> clazz = context2.getClassLoader().loadClass("com.google.android.gms.common.security.ProviderInstallerImpl");
                    Class[] classArray = new Class[]{Context.class};
                    zzbCH = clazz.getMethod("insertProvider", classArray);
                }
                zzbCH.invoke(null, context2);
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"ProviderInstaller", (String)(string2.length() != 0 ? "Failed to install provider: ".concat(string2) : new String("Failed to install provider: ")));
                throw new GooglePlayServicesNotAvailableException(8);
            }
            return;
        }
    }

    public static void installIfNeededAsync(Context context, ProviderInstallListener providerInstallListener) {
        zzbo.zzb(context, (Object)"Context must not be null");
        zzbo.zzb(providerInstallListener, (Object)"Listener must not be null");
        zzbo.zzcz("Must be called on the UI thread");
        new zza(context, providerInstallListener).execute(new Void[0]);
    }

    static /* synthetic */ zze zzAo() {
        return zzbCG;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, Intent var2);
    }
}

