/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzag;
import com.google.android.gms.common.internal.zzah;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

final class zzai
implements ServiceConnection {
    private final Set<ServiceConnection> zzfuw;
    private int mState;
    private boolean zzfux;
    private IBinder zzftk;
    private final zzag zzfuy;
    private ComponentName zzfuq;
    private /* synthetic */ zzah zzfuz;

    public zzai(zzah zzah2, zzag zzag2) {
        this.zzfuz = zzah2;
        this.zzfuy = zzag2;
        this.zzfuw = new HashSet<ServiceConnection>();
        this.mState = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzah.zza(this.zzfuz);
        synchronized (hashMap) {
            zzah.zzb(this.zzfuz).removeMessages(1, (Object)this.zzfuy);
            this.zzftk = iBinder;
            this.zzfuq = componentName;
            Iterator<ServiceConnection> iterator = this.zzfuw.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            this.mState = 1;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzah.zza(this.zzfuz);
        synchronized (hashMap) {
            zzah.zzb(this.zzfuz).removeMessages(1, (Object)this.zzfuy);
            this.zzftk = null;
            this.zzfuq = componentName;
            Iterator<ServiceConnection> iterator = this.zzfuw.iterator();
            while (iterator.hasNext()) {
                iterator.next().onServiceDisconnected(componentName);
            }
            this.mState = 2;
            return;
        }
    }

    public final void zzgb(String string2) {
        this.mState = 3;
        this.zzfux = zzah.zzd(this.zzfuz).zza(zzah.zzc(this.zzfuz), string2, this.zzfuy.zzakh(), this, this.zzfuy.zzakg());
        if (this.zzfux) {
            Message message = zzah.zzb(this.zzfuz).obtainMessage(1, (Object)this.zzfuy);
            zzah.zzb(this.zzfuz).sendMessageDelayed(message, zzah.zze(this.zzfuz));
            return;
        }
        this.mState = 2;
        try {
            zzah.zzd(this.zzfuz);
            zzai zzai2 = this;
            Context context = zzah.zzc(this.zzfuz);
            context.unbindService((ServiceConnection)zzai2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public final void zzgc(String string2) {
        zzah.zzb(this.zzfuz).removeMessages(1, (Object)this.zzfuy);
        zzah.zzd(this.zzfuz);
        zzai zzai2 = this;
        Context context = zzah.zzc(this.zzfuz);
        context.unbindService((ServiceConnection)zzai2);
        this.zzfux = false;
        this.mState = 2;
    }

    public final void zza(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzfuz);
        zzah.zzc(this.zzfuz);
        this.zzfuy.zzakh();
        this.zzfuw.add(serviceConnection);
    }

    public final void zzb(ServiceConnection serviceConnection, String string2) {
        zzah.zzd(this.zzfuz);
        zzah.zzc(this.zzfuz);
        this.zzfuw.remove(serviceConnection);
    }

    public final boolean isBound() {
        return this.zzfux;
    }

    public final int getState() {
        return this.mState;
    }

    public final boolean zza(ServiceConnection serviceConnection) {
        return this.zzfuw.contains(serviceConnection);
    }

    public final boolean zzaki() {
        return this.zzfuw.isEmpty();
    }

    public final IBinder getBinder() {
        return this.zzftk;
    }

    public final ComponentName getComponentName() {
        return this.zzfuq;
    }
}

