/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzg;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.zzbf;
import com.google.android.gms.internal.zzbck;
import com.google.android.gms.internal.zzbcn;
import java.util.Arrays;

public final class Status
extends zzbck
implements Result,
ReflectedParcelable {
    public static final Status zzfhu = new Status(0);
    public static final Status zzfhv = new Status(14);
    public static final Status zzfhw = new Status(8);
    public static final Status zzfhx = new Status(15);
    public static final Status zzfhy = new Status(16);
    private static Status zzfhz = new Status(17);
    private static Status zzfia = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzg();
    private int zzdxr;
    private final int zzfab;
    @Nullable
    private final String zzfff;
    @Nullable
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this.zzdxr = n;
        this.zzfab = n2;
        this.zzfff = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, @Nullable String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, @Nullable String string2, @Nullable PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    @Nullable
    public final String getStatusMessage() {
        return this.zzfff;
    }

    public final boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public final boolean isSuccess() {
        return this.zzfab <= 0;
    }

    public final boolean isCanceled() {
        return this.zzfab == 16;
    }

    public final boolean isInterrupted() {
        return this.zzfab == 14;
    }

    public final int getStatusCode() {
        return this.zzfab;
    }

    public final PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzdxr, this.zzfab, this.zzfff, this.mPendingIntent});
    }

    public final boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.zzdxr == status.zzdxr && this.zzfab == status.zzfab && zzbf.equal(this.zzfff, status.zzfff) && zzbf.equal(this.mPendingIntent, status.mPendingIntent);
    }

    public final String zzafu() {
        if (this.zzfff != null) {
            return this.zzfff;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzfab);
    }

    public final String toString() {
        return zzbf.zzt(this).zzg("statusCode", this.zzafu()).zzg("resolution", this.mPendingIntent).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Status status = this;
        int n2 = zzbcn.zze(parcel2);
        zzbcn.zzc(parcel2, 1, status.getStatusCode());
        zzbcn.zza(parcel2, 2, status.getStatusMessage(), false);
        zzbcn.zza(parcel2, 3, (Parcelable)status.mPendingIntent, n, false);
        zzbcn.zzc(parcel2, 1000, status.zzdxr);
        zzbcn.zzai(parcel2, n2);
    }

    @Override
    public final Status getStatus() {
        return this;
    }
}

