/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzde;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzdd
extends Fragment
implements zzci {
    private static WeakHashMap<FragmentActivity, WeakReference<zzdd>> zzfru = new WeakHashMap();
    private Map<String, LifecycleCallback> zzfrv = new ArrayMap();
    private int zzbzn = 0;
    private Bundle zzfrw;

    public static zzdd zza(FragmentActivity fragmentActivity) {
        zzdd zzdd2;
        WeakReference<zzdd> weakReference = zzfru.get(fragmentActivity);
        if (weakReference != null && (zzdd2 = (zzdd)weakReference.get()) != null) {
            return zzdd2;
        }
        try {
            zzdd2 = (zzdd)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", classCastException);
        }
        if (zzdd2 == null || zzdd2.isRemoving()) {
            zzdd2 = new zzdd();
            fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)zzdd2, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzfru.put(fragmentActivity, new WeakReference<zzdd>(zzdd2));
        return zzdd2;
    }

    @Override
    public final <T extends LifecycleCallback> T zza(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzfrv.get(string2)));
    }

    @Override
    public final void zza(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzfrv.containsKey(string2)) {
            this.zzfrv.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzdd zzdd2 = this;
            if (zzdd2.zzbzn > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzde(zzdd2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbzn = 1;
        this.zzfrw = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfrv.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzbzn = 2;
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzbzn = 3;
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfrv.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzbzn = 4;
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzbzn = 5;
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzfrv.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    public final /* synthetic */ Activity zzajc() {
        return this.getActivity();
    }

    static /* synthetic */ int zza(zzdd zzdd2) {
        return zzdd2.zzbzn;
    }

    static /* synthetic */ Bundle zzb(zzdd zzdd2) {
        return zzdd2.zzfrw;
    }
}

