/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.zzci;
import com.google.android.gms.common.api.internal.zzck;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzcj
extends Fragment
implements zzci {
    private static WeakHashMap<Activity, WeakReference<zzcj>> zzfrk = new WeakHashMap();
    private Map<String, LifecycleCallback> zzfrl = new ArrayMap();
    private int zzbzn = 0;
    private Bundle zzfrm;

    public static zzcj zzo(Activity activity) {
        zzcj zzcj2;
        WeakReference<zzcj> weakReference = zzfrk.get(activity);
        if (weakReference != null && (zzcj2 = (zzcj)weakReference.get()) != null) {
            return zzcj2;
        }
        try {
            zzcj2 = (zzcj)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzcj2 == null || zzcj2.isRemoving()) {
            zzcj2 = new zzcj();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzcj2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzfrk.put(activity, new WeakReference<zzcj>(zzcj2));
        return zzcj2;
    }

    @Override
    public final <T extends LifecycleCallback> T zza(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzfrl.get(string2)));
    }

    @Override
    public final void zza(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzfrl.containsKey(string2)) {
            this.zzfrl.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzcj zzcj2 = this;
            if (zzcj2.zzbzn > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzck(zzcj2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final Activity zzajb() {
        return this.getActivity();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbzn = 1;
        this.zzfrm = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfrl.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzbzn = 2;
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzbzn = 3;
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzfrl.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzbzn = 4;
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzbzn = 5;
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzfrl.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zza(zzcj zzcj2) {
        return zzcj2.zzbzn;
    }

    static /* synthetic */ Bundle zzb(zzcj zzcj2) {
        return zzcj2.zzfrm;
    }
}

