/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.identifier;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.ads.identifier.zzb;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.annotation.KeepForSdkWithMembers;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzfq;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@KeepForSdkWithMembers
public class AdvertisingIdClient {
    @Nullable
    private com.google.android.gms.common.zza zza;
    @Nullable
    private zzfp zzb;
    private boolean zzc;
    private Object zzd = new Object();
    @Nullable
    private zza zze;
    private final Context zzf;
    private boolean zzg;
    private long zzh;

    @Hide
    public AdvertisingIdClient(Context context) {
        this(context, 30000L, false, false);
    }

    @Hide
    public AdvertisingIdClient(Context context, long l, boolean bl, boolean bl2) {
        Context context2;
        zzbq.zza(context);
        this.zzf = bl ? ((context2 = context.getApplicationContext()) == null ? context : context2) : context;
        this.zzc = false;
        this.zzh = l;
        this.zzg = bl2;
    }

    @Hide
    public void start() throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        this.zza(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    private final void zza(boolean bl) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzbq.zzc("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzc) {
                this.finish();
            }
            this.zza = AdvertisingIdClient.zza(this.zzf, this.zzg);
            this.zzb = AdvertisingIdClient.zza(this.zzf, this.zza);
            this.zzc = true;
            if (bl) {
                this.zza();
            }
            return;
        }
    }

    @Hide
    public static void setShouldSkipGmsCoreVersionCheck(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza() {
        Object object = this.zzd;
        synchronized (object) {
            if (this.zze != null) {
                this.zze.zza.countDown();
                try {
                    this.zze.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.zzh > 0L) {
                this.zze = new zza(this, this.zzh);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public Info getInfo() throws IOException {
        Info info;
        zzbq.zzc("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzc) {
                Object object = this.zzd;
                synchronized (object) {
                    if (this.zze == null || !this.zze.zzb) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zza(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzc) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.zza(this.zza);
            zzbq.zza(this.zzb);
            try {
                info = new Info(this.zzb.zza(), this.zzb.zza(true));
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zza();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public boolean getIsAdIdFakeForDebugLogging() throws IOException {
        boolean bl;
        zzbq.zzc("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (!this.zzc) {
                Object object = this.zzd;
                synchronized (object) {
                    if (this.zze == null || !this.zze.zzb) {
                        throw new IOException("AdvertisingIdClient is not connected.");
                    }
                }
                try {
                    this.zza(false);
                }
                catch (Exception exception) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.", exception);
                }
                if (!this.zzc) {
                    throw new IOException("AdvertisingIdClient cannot reconnect.");
                }
            }
            zzbq.zza(this.zza);
            zzbq.zza(this.zzb);
            try {
                bl = this.zzb.zzb();
            }
            catch (RemoteException remoteException) {
                Log.i((String)"AdvertisingIdClient", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("Remote exception");
            }
        }
        this.zza();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Hide
    public void finish() {
        zzbq.zzc("Calling this from your main thread can lead to deadlock");
        AdvertisingIdClient advertisingIdClient = this;
        synchronized (advertisingIdClient) {
            if (this.zzf == null || this.zza == null) {
                return;
            }
            try {
                if (this.zzc) {
                    com.google.android.gms.common.stats.zza.zza();
                    com.google.android.gms.common.zza zza2 = this.zza;
                    Context context = this.zzf;
                    context.unbindService((ServiceConnection)zza2);
                }
            }
            catch (Throwable throwable) {
                Log.i((String)"AdvertisingIdClient", (String)"AdvertisingIdClient unbindService failed.", (Throwable)throwable);
            }
            this.zzc = false;
            this.zzb = null;
            this.zza = null;
            return;
        }
    }

    @Hide
    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static com.google.android.gms.common.zza zza(Context context, boolean bl) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        try {
            context.getPackageManager().getPackageInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new GooglePlayServicesNotAvailableException(9);
        }
        switch (com.google.android.gms.common.zzf.zza().isGooglePlayServicesAvailable(context)) {
            case 0: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Google Play services not available");
            }
        }
        String string2 = bl ? "com.google.android.gms.ads.identifier.service.PERSISTENT_START" : "com.google.android.gms.ads.identifier.service.START";
        com.google.android.gms.common.zza zza2 = new com.google.android.gms.common.zza();
        Intent intent = new Intent(string2);
        intent.setPackage("com.google.android.gms");
        try {
            if (com.google.android.gms.common.stats.zza.zza().zza(context, intent, zza2, 1)) {
                return zza2;
            }
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
        throw new IOException("Connection failure");
    }

    public static Info getAdvertisingIdInfo(Context context) throws IOException, IllegalStateException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.zza("gads:ad_id_app_context:enabled", false);
        float f = zzb2.zza("gads:ad_id_app_context:ping_ratio", 0.0f);
        String string2 = zzb2.zza("gads:ad_id_use_shared_preference:experiment_id", "");
        boolean bl2 = zzb2.zza("gads:ad_id_use_persistent_service:enabled", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            long l = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(false);
            Info info = advertisingIdClient.getInfo();
            long l2 = SystemClock.elapsedRealtime();
            advertisingIdClient.zza(info, bl, f, l2 - l, string2, null);
            Info info2 = info;
            return info2;
        }
        catch (Throwable throwable) {
            advertisingIdClient.zza(null, bl, f, -1L, string2, throwable);
            throw throwable;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    @Hide
    public static boolean getIsAdIdFakeForDebugLogging(Context context) throws IOException, GooglePlayServicesNotAvailableException, GooglePlayServicesRepairableException {
        zzb zzb2 = new zzb(context);
        boolean bl = zzb2.zza("gads:ad_id_app_context:enabled", false);
        boolean bl2 = zzb2.zza("com.google.android.gms.ads.identifier.service.PERSISTENT_START", false);
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(context, -1L, bl, bl2);
        try {
            advertisingIdClient.zza(false);
            boolean bl3 = advertisingIdClient.getIsAdIdFakeForDebugLogging();
            return bl3;
        }
        finally {
            advertisingIdClient.finish();
        }
    }

    private final boolean zza(Info info, boolean bl, float f, long l, String string2, Throwable throwable) {
        if (Math.random() > (double)f) {
            return false;
        }
        Throwable throwable2 = throwable;
        String string3 = string2;
        long l2 = l;
        boolean bl2 = bl;
        Info info2 = info;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("app_context", bl2 ? "1" : "0");
        if (info2 != null) {
            hashMap.put("limit_ad_tracking", info2.isLimitAdTrackingEnabled() ? "1" : "0");
        }
        if (info2 != null && info2.getId() != null) {
            hashMap.put("ad_id_size", Integer.toString(info2.getId().length()));
        }
        if (throwable2 != null) {
            hashMap.put("error", throwable2.getClass().getName());
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("experiment_id", string3);
        }
        hashMap.put("tag", "AdvertisingIdClient");
        hashMap.put("time_spent", Long.toString(l2));
        HashMap<String, String> hashMap2 = hashMap;
        new com.google.android.gms.ads.identifier.zza(this, hashMap2).start();
        return true;
    }

    @Hide
    private static zzfp zza(Context context, com.google.android.gms.common.zza zza2) throws IOException {
        try {
            return zzfq.zza(zza2.zza(10000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted exception");
        }
        catch (Throwable throwable) {
            throw new IOException(throwable);
        }
    }

    public static final class Info {
        private final String zza;
        private final boolean zzb;

        public Info(String string2, boolean bl) {
            this.zza = string2;
            this.zzb = bl;
        }

        public final String getId() {
            return this.zza;
        }

        public final boolean isLimitAdTrackingEnabled() {
            return this.zzb;
        }

        public final String toString() {
            String string2 = this.zza;
            boolean bl = this.zzb;
            return new StringBuilder(7 + String.valueOf(string2).length()).append("{").append(string2).append("}").append(bl).toString();
        }
    }

    @Hide
    static final class zza
    extends Thread {
        private WeakReference<AdvertisingIdClient> zzc;
        private long zzd;
        CountDownLatch zza;
        boolean zzb;

        public zza(AdvertisingIdClient advertisingIdClient, long l) {
            this.zzc = new WeakReference<AdvertisingIdClient>(advertisingIdClient);
            this.zzd = l;
            this.zza = new CountDownLatch(1);
            this.zzb = false;
            this.start();
        }

        private final void zza() {
            AdvertisingIdClient advertisingIdClient = (AdvertisingIdClient)this.zzc.get();
            if (advertisingIdClient != null) {
                advertisingIdClient.finish();
                this.zzb = true;
            }
        }

        @Override
        public final void run() {
            try {
                if (!this.zza.await(this.zzd, TimeUnit.MILLISECONDS)) {
                    this.zza();
                }
                return;
            }
            catch (InterruptedException interruptedException) {
                this.zza();
                return;
            }
        }
    }
}

