/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbg;
import com.google.android.gms.common.zzb;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzbgo;
import java.util.Arrays;

public final class ConnectionResult
extends zzbgl {
    public static final int SUCCESS = 0;
    public static final int SERVICE_MISSING = 1;
    public static final int SERVICE_VERSION_UPDATE_REQUIRED = 2;
    public static final int SERVICE_DISABLED = 3;
    public static final int SIGN_IN_REQUIRED = 4;
    public static final int INVALID_ACCOUNT = 5;
    public static final int RESOLUTION_REQUIRED = 6;
    public static final int NETWORK_ERROR = 7;
    public static final int INTERNAL_ERROR = 8;
    public static final int SERVICE_INVALID = 9;
    public static final int DEVELOPER_ERROR = 10;
    public static final int LICENSE_CHECK_FAILED = 11;
    public static final int CANCELED = 13;
    public static final int TIMEOUT = 14;
    public static final int INTERRUPTED = 15;
    public static final int API_UNAVAILABLE = 16;
    public static final int SIGN_IN_FAILED = 17;
    public static final int SERVICE_UPDATING = 18;
    public static final int SERVICE_MISSING_PERMISSION = 19;
    public static final int RESTRICTED_PROFILE = 20;
    @Deprecated
    public static final int DRIVE_EXTERNAL_STORAGE_REQUIRED = 1500;
    @Hide
    public static final ConnectionResult zza = new ConnectionResult(0);
    public static final Parcelable.Creator<ConnectionResult> CREATOR = new zzb();
    private int zzb;
    private final int zzc;
    private final PendingIntent zzd;
    private final String zze;

    ConnectionResult(int n, int n2, PendingIntent pendingIntent, String string) {
        this.zzb = n;
        this.zzc = n2;
        this.zzd = pendingIntent;
        this.zze = string;
    }

    public ConnectionResult(int n) {
        this(n, null, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent) {
        this(n, pendingIntent, null);
    }

    public ConnectionResult(int n, PendingIntent pendingIntent, String string) {
        this(1, n, pendingIntent, string);
    }

    public final void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.zzd.getIntentSender(), n, null, 0, 0, 0);
    }

    public final boolean hasResolution() {
        return this.zzc != 0 && this.zzd != null;
    }

    public final boolean isSuccess() {
        return this.zzc == 0;
    }

    public final int getErrorCode() {
        return this.zzc;
    }

    @Nullable
    public final PendingIntent getResolution() {
        return this.zzd;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.zze;
    }

    static String zza(int n) {
        switch (n) {
            case 0: {
                return "SUCCESS";
            }
            case 1: {
                return "SERVICE_MISSING";
            }
            case 2: {
                return "SERVICE_VERSION_UPDATE_REQUIRED";
            }
            case 3: {
                return "SERVICE_DISABLED";
            }
            case 4: {
                return "SIGN_IN_REQUIRED";
            }
            case 5: {
                return "INVALID_ACCOUNT";
            }
            case 6: {
                return "RESOLUTION_REQUIRED";
            }
            case 7: {
                return "NETWORK_ERROR";
            }
            case 8: {
                return "INTERNAL_ERROR";
            }
            case 9: {
                return "SERVICE_INVALID";
            }
            case 10: {
                return "DEVELOPER_ERROR";
            }
            case 11: {
                return "LICENSE_CHECK_FAILED";
            }
            case 13: {
                return "CANCELED";
            }
            case 14: {
                return "TIMEOUT";
            }
            case 15: {
                return "INTERRUPTED";
            }
            case 16: {
                return "API_UNAVAILABLE";
            }
            case 17: {
                return "SIGN_IN_FAILED";
            }
            case 18: {
                return "SERVICE_UPDATING";
            }
            case 19: {
                return "SERVICE_MISSING_PERMISSION";
            }
            case 20: {
                return "RESTRICTED_PROFILE";
            }
            case 21: {
                return "API_VERSION_UPDATE_REQUIRED";
            }
            case 1500: {
                return "DRIVE_EXTERNAL_STORAGE_REQUIRED";
            }
            case 99: {
                return "UNFINISHED";
            }
            case -1: {
                return "UNKNOWN";
            }
        }
        return new StringBuilder(31).append("UNKNOWN_ERROR_CODE(").append(n).append(")").toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConnectionResult)) {
            return false;
        }
        ConnectionResult connectionResult = (ConnectionResult)object;
        return this.zzc == connectionResult.zzc && zzbg.zza(this.zzd, connectionResult.zzd) && zzbg.zza(this.zze, connectionResult.zze);
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.zzc, this.zzd, this.zze});
    }

    public final String toString() {
        return zzbg.zza(this).zza("statusCode", ConnectionResult.zza(this.zzc)).zza("resolution", this.zzd).zza("message", this.zze).toString();
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ConnectionResult connectionResult = this;
        int n2 = zzbgo.zza(parcel2);
        zzbgo.zza(parcel2, 1, connectionResult.zzb);
        zzbgo.zza(parcel2, 2, connectionResult.getErrorCode());
        zzbgo.zza(parcel2, 3, (Parcelable)connectionResult.getResolution(), n, false);
        zzbgo.zza(parcel2, 4, connectionResult.getErrorMessage(), false);
        zzbgo.zza(parcel2, n2);
    }
}

