/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzcd;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzcc
extends Fragment
implements LifecycleFragment {
    private static WeakHashMap<FragmentActivity, WeakReference<zzcc>> zzla = new WeakHashMap();
    private Map<String, LifecycleCallback> zzlb = new ArrayMap();
    private int zzlc = 0;
    private Bundle zzld;

    public static zzcc zza(FragmentActivity fragmentActivity) {
        zzcc zzcc2;
        WeakReference<zzcc> weakReference = zzla.get(fragmentActivity);
        if (weakReference != null && (zzcc2 = (zzcc)weakReference.get()) != null) {
            return zzcc2;
        }
        try {
            zzcc2 = (zzcc)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", classCastException);
        }
        if (zzcc2 == null || zzcc2.isRemoving()) {
            zzcc2 = new zzcc();
            fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)zzcc2, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzla.put(fragmentActivity, new WeakReference<zzcc>(zzcc2));
        return zzcc2;
    }

    @Override
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzlb.get(string2)));
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzlb.containsKey(string2)) {
            this.zzlb.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzcc zzcc2 = this;
            if (zzcc2.zzlc > 0) {
                new Handler(Looper.getMainLooper()).post((Runnable)new zzcd(zzcc2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final boolean isCreated() {
        return this.zzlc > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzlc >= 2;
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzlc = 1;
        this.zzld = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzlb.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzlc = 2;
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzlc = 3;
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzlb.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzlc = 4;
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzlc = 5;
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzlb.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    @Override
    public final /* synthetic */ Activity getLifecycleActivity() {
        return this.getActivity();
    }

    static /* synthetic */ int zza(zzcc zzcc2) {
        return zzcc2.zzlc;
    }

    static /* synthetic */ Bundle zzb(zzcc zzcc2) {
        return zzcc2.zzld;
    }
}

