/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AccountAccessor;
import com.google.android.gms.common.internal.GetServiceRequestCreator;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collection;

@SafeParcelable.Reserved(value={9})
@SafeParcelable.Class(creator="GetServiceRequestCreator")
public class GetServiceRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GetServiceRequest> CREATOR = new GetServiceRequestCreator();
    @SafeParcelable.VersionField(id=1)
    private final int version;
    @SafeParcelable.Field(id=2)
    private final int zzst;
    @SafeParcelable.Field(id=3)
    private int zzsu;
    @SafeParcelable.Field(id=4)
    private String zzsv;
    @SafeParcelable.Field(id=5)
    private IBinder zzsw;
    @SafeParcelable.Field(id=6)
    private Scope[] zzsx;
    @SafeParcelable.Field(id=7)
    private Bundle zzsy;
    @SafeParcelable.Field(id=8)
    private Account zzsz;
    @SafeParcelable.Field(id=10)
    private Feature[] zzta;
    @SafeParcelable.Field(id=11)
    private Feature[] zztb;
    @SafeParcelable.Field(id=12)
    private boolean zztc;

    public GetServiceRequest(int n) {
        this.version = 4;
        this.zzsu = GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        this.zzst = n;
        this.zztc = true;
    }

    @SafeParcelable.Constructor
    GetServiceRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) int n2, @SafeParcelable.Param(id=3) int n3, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) IBinder iBinder, @SafeParcelable.Param(id=6) Scope[] scopeArray, @SafeParcelable.Param(id=7) Bundle bundle, @SafeParcelable.Param(id=8) Account account, @SafeParcelable.Param(id=10) Feature[] featureArray, @SafeParcelable.Param(id=11) Feature[] featureArray2, @SafeParcelable.Param(id=12) boolean bl) {
        this.version = n;
        this.zzst = n2;
        this.zzsu = n3;
        this.zzsv = "com.google.android.gms".equals(string2) ? "com.google.android.gms" : string2;
        if (n < 2) {
            this.zzsz = GetServiceRequest.zzb(iBinder);
        } else {
            this.zzsw = iBinder;
            this.zzsz = account;
        }
        this.zzsx = scopeArray;
        this.zzsy = bundle;
        this.zzta = featureArray;
        this.zztb = featureArray2;
        this.zztc = bl;
    }

    public int getClientLibraryVersion() {
        return this.zzsu;
    }

    public GetServiceRequest setClientLibraryVersion(int n) {
        this.zzsu = n;
        return this;
    }

    public Feature[] getClientRequiredFeatures() {
        return this.zzta;
    }

    public GetServiceRequest setClientRequiredFeatures(Feature[] featureArray) {
        this.zzta = featureArray;
        return this;
    }

    public Feature[] getClientApiFeatures() {
        return this.zztb;
    }

    public GetServiceRequest setClientApiFeatures(Feature[] featureArray) {
        this.zztb = featureArray;
        return this;
    }

    public boolean isRequestingConnectionInfo() {
        return this.zztc;
    }

    public GetServiceRequest setRequestingConnectionInfo(boolean bl) {
        this.zztc = bl;
        return this;
    }

    public int getServiceId() {
        return this.zzst;
    }

    public String getCallingPackage() {
        return this.zzsv;
    }

    public GetServiceRequest setCallingPackage(String string2) {
        this.zzsv = string2;
        return this;
    }

    public Account getClientRequestedAccount() {
        return this.zzsz;
    }

    public GetServiceRequest setClientRequestedAccount(Account account) {
        this.zzsz = account;
        return this;
    }

    public Account getAuthenticatedAccount() {
        return GetServiceRequest.zzb(this.zzsw);
    }

    public GetServiceRequest setAuthenticatedAccount(IAccountAccessor iAccountAccessor) {
        if (iAccountAccessor != null) {
            this.zzsw = iAccountAccessor.asBinder();
        }
        return this;
    }

    public Scope[] getScopes() {
        return this.zzsx;
    }

    public GetServiceRequest setScopes(Collection<Scope> collection) {
        this.zzsx = collection.toArray(new Scope[collection.size()]);
        return this;
    }

    public Bundle getExtraArgs() {
        return this.zzsy;
    }

    public GetServiceRequest setExtraArgs(Bundle bundle) {
        this.zzsy = bundle;
        return this;
    }

    public static Parcelable.Creator<GetServiceRequest> getCreator() {
        return CREATOR;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GetServiceRequest getServiceRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, getServiceRequest.version);
        SafeParcelWriter.writeInt(parcel2, 2, getServiceRequest.zzst);
        SafeParcelWriter.writeInt(parcel2, 3, getServiceRequest.zzsu);
        SafeParcelWriter.writeString(parcel2, 4, getServiceRequest.zzsv, false);
        SafeParcelWriter.writeIBinder(parcel2, 5, getServiceRequest.zzsw, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)6, (Parcelable[])getServiceRequest.zzsx, (int)n, (boolean)false);
        SafeParcelWriter.writeBundle(parcel2, 7, getServiceRequest.zzsy, false);
        SafeParcelWriter.writeParcelable(parcel2, 8, (Parcelable)getServiceRequest.zzsz, n, false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)10, (Parcelable[])getServiceRequest.zzta, (int)n, (boolean)false);
        SafeParcelWriter.writeTypedArray((Parcel)parcel2, (int)11, (Parcelable[])getServiceRequest.zztb, (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean(parcel2, 12, getServiceRequest.zztc);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    private static Account zzb(IBinder iBinder) {
        Account account = null;
        if (iBinder != null) {
            account = AccountAccessor.getAccountBinderSafe(IAccountAccessor.Stub.asInterface(iBinder));
        }
        return account;
    }
}

