/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.util.Log;
import com.google.android.gms.common.internal.Preconditions;

public final class GmsLogger {
    public static final int MAX_TAG_LENGTH = 23;
    public static final int MAX_PII_TAG_LENGTH = 15;
    private static final String zzub = null;
    private final String zzuc;
    private final String zzud;

    public static boolean isBuildPiiEnabled() {
        return true;
    }

    public GmsLogger(String string2, String string3) {
        Preconditions.checkNotNull(string2, "log tag cannot be null");
        Preconditions.checkArgument(string2.length() <= 23, "tag \"%s\" is longer than the %d character maximum", string2, 23);
        this.zzuc = string2;
        if (string3 == null || string3.length() <= 0) {
            this.zzud = null;
            return;
        }
        this.zzud = string3;
    }

    public GmsLogger(String string2) {
        this(string2, null);
    }

    public final GmsLogger withMessagePrefix(String string2) {
        return new GmsLogger(this.zzuc, string2);
    }

    public final String getTag() {
        return this.zzuc;
    }

    public final boolean canLog(int n) {
        return Log.isLoggable((String)this.zzuc, (int)n);
    }

    public final boolean canLogPii() {
        return this.canLog(4);
    }

    public final void d(String string2, String string3) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zzl(string3));
        }
    }

    public final void d(String string2, String string3, Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void dfmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    public final void v(String string2, String string3) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zzl(string3));
        }
    }

    public final void v(String string2, String string3, Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void vfmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    public final void i(String string2, String string3) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zzl(string3));
        }
    }

    public final void i(String string2, String string3, Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void ifmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    public final void w(String string2, String string3) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zzl(string3));
        }
    }

    public final void w(String string2, String string3, Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void wfmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(5)) {
            Log.w((String)this.zzuc, (String)this.zza(string3, objectArray));
        }
    }

    public final void e(String string2, String string3) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zzl(string3));
        }
    }

    public final void e(String string2, String string3, Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void efmt(String string2, String string3, Object ... objectArray) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    public final void wtf(String string2, String string3, Throwable throwable) {
        if (this.canLog(7)) {
            Log.e((String)string2, (String)this.zzl(string3), (Throwable)throwable);
            Log.wtf((String)string2, (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void pii(String string2, String string3) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zzl(string3));
        }
    }

    public final void pii(String string2, String string3, Throwable throwable) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zzl(string3), (Throwable)throwable);
        }
    }

    public final void piifmt(String string2, String string3, Object ... objectArray) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zza(string3, objectArray));
        }
    }

    private final String zzl(String string2) {
        if (this.zzud == null) {
            return string2;
        }
        return this.zzud.concat(string2);
    }

    private final String zza(String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        if (this.zzud == null) {
            return string3;
        }
        return this.zzud.concat(string3);
    }
}

