/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.stats.ConnectionTracker;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;

final class zze
extends GmsClientSupervisor
implements Handler.Callback {
    @GuardedBy(value="mConnectionStatus")
    private final HashMap<GmsClientSupervisor.zza, zzf> zzdu = new HashMap();
    private final Context zzdv;
    private final Handler mHandler;
    private final ConnectionTracker zzdw;
    private final long zzdx;
    private final long zzdy;

    zze(Context context) {
        this.zzdv = context.getApplicationContext();
        this.mHandler = new com.google.android.gms.internal.common.zze(context.getMainLooper(), this);
        this.zzdw = ConnectionTracker.getInstance();
        this.zzdx = 5000L;
        this.zzdy = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.zza, zzf> hashMap = this.zzdu;
        synchronized (hashMap) {
            zzf zzf2 = this.zzdu.get(zza2);
            if (zzf2 == null) {
                zzf2 = new zzf(this, zza2);
                zzf2.zza(serviceConnection, string2);
                zzf2.zze(string2);
                this.zzdu.put(zza2, zzf2);
            } else {
                this.mHandler.removeMessages(0, (Object)zza2);
                if (zzf2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzf2.zza(serviceConnection, string2);
                switch (zzf2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzf2.getComponentName(), zzf2.getBinder());
                        break;
                    }
                    case 2: {
                        zzf2.zze(string2);
                    }
                }
            }
            return zzf2.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void zzb(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.zza, zzf> hashMap = this.zzdu;
        synchronized (hashMap) {
            zzf zzf2 = this.zzdu.get(zza2);
            if (zzf2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzf2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzf2.zzb(serviceConnection, string2);
            if (zzf2.zzr()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zza2);
                this.mHandler.sendMessageDelayed(message, this.zzdx);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<GmsClientSupervisor.zza, zzf> hashMap = this.zzdu;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza2 = (GmsClientSupervisor.zza)message.obj;
                    zzf zzf2 = this.zzdu.get(zza2);
                    if (zzf2 != null && zzf2.zzr()) {
                        if (zzf2.isBound()) {
                            zzf2.zzf("GmsClientSupervisor");
                        }
                        this.zzdu.remove(zza2);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<GmsClientSupervisor.zza, zzf> hashMap = this.zzdu;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza3 = (GmsClientSupervisor.zza)message.obj;
                    zzf zzf3 = this.zzdu.get(zza3);
                    if (zzf3 != null && zzf3.getState() == 3) {
                        String string2 = String.valueOf(zza3);
                        Log.wtf((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zzf3.getComponentName();
                        if (string2 == null) {
                            string2 = zza3.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(zza3.getPackage(), "unknown");
                        }
                        zzf3.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ HashMap zza(zze zze2) {
        return zze2.zzdu;
    }

    static /* synthetic */ Handler zzb(zze zze2) {
        return zze2.mHandler;
    }

    static /* synthetic */ Context zzc(zze zze2) {
        return zze2.zzdv;
    }

    static /* synthetic */ ConnectionTracker zzd(zze zze2) {
        return zze2.zzdw;
    }

    static /* synthetic */ long zze(zze zze2) {
        return zze2.zzdy;
    }
}

