/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.common.zzn;
import com.google.android.gms.internal.common.zzo;
import java.util.concurrent.ConcurrentHashMap;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zza = new Object();
    private static volatile ConnectionTracker zzb;
    @VisibleForTesting
    private static boolean zzc;
    private static zzo<Boolean> zzd;
    @VisibleForTesting
    private ConcurrentHashMap<ServiceConnection, ServiceConnection> zze = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public static ConnectionTracker getInstance() {
        if (zzb == null) {
            Object object = zza;
            synchronized (object) {
                if (zzb == null) {
                    zzb = new ConnectionTracker();
                }
            }
        }
        return zzb;
    }

    private ConnectionTracker() {
    }

    public final boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, string2, intent, serviceConnection, n, true);
    }

    @SuppressLint(value={"UntrackedBindService"})
    private final boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n, boolean bl) {
        boolean bl2;
        block4: {
            block5: {
                Intent intent2 = intent;
                Context context2 = context;
                ComponentName componentName = intent2.getComponent();
                if (componentName == null ? false : ClientLibraryUtils.zza(context2, componentName.getPackageName())) {
                    Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
                    return false;
                }
                if (!ConnectionTracker.zza(serviceConnection)) break block5;
                ServiceConnection serviceConnection2 = serviceConnection;
                ServiceConnection serviceConnection3 = serviceConnection2;
                ServiceConnection serviceConnection4 = this.zze.putIfAbsent(serviceConnection, serviceConnection3);
                if (serviceConnection4 != null && serviceConnection3 != serviceConnection4) {
                    String string3 = String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", serviceConnection, string2, intent.getAction());
                    Log.w((String)"ConnectionTracker", (String)string3);
                }
                try {
                    bl2 = context.bindService(intent, serviceConnection3, n);
                    if (bl2) break block4;
                    this.zze.remove(serviceConnection, serviceConnection3);
                }
                catch (Throwable throwable) {
                    this.zze.remove(serviceConnection, serviceConnection3);
                    throw throwable;
                }
                break block4;
            }
            bl2 = context.bindService(intent, serviceConnection, n);
        }
        return bl2;
    }

    @KeepForSdk
    public boolean bindService(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindService(Context context, ServiceConnection serviceConnection) {
        if (ConnectionTracker.zza(serviceConnection) && this.zze.containsKey(serviceConnection)) {
            try {
                ConnectionTracker.zza(context, this.zze.get(serviceConnection));
                return;
            }
            finally {
                this.zze.remove(serviceConnection);
            }
        }
        ConnectionTracker.zza(context, serviceConnection);
    }

    private static boolean zza(ServiceConnection serviceConnection) {
        return zzd.zza() != false && !(serviceConnection instanceof zzj);
    }

    @SuppressLint(value={"UntrackedBindService"})
    private static void zza(Context context, ServiceConnection serviceConnection) {
        try {
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            Log.w((String)"ConnectionTracker", (String)"Exception thrown while unbinding", (Throwable)runtimeException);
            return;
        }
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindServiceSafe(Context context, ServiceConnection serviceConnection) {
        try {
            this.unbindService(context, serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)"ConnectionTracker", (String)"Exception thrown while unbinding", (Throwable)illegalArgumentException);
            return;
        }
    }

    static final /* synthetic */ boolean zza() {
        return false;
    }

    static {
        zzc = false;
        zzd = zzn.zza(com.google.android.gms.common.stats.zza.zza);
    }
}

