/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.BinderThread;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ConnectionTelemetryConfiguration;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    @RecentlyNonNull
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    @RecentlyNonNull
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    @RecentlyNonNull
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzd = new Feature[0];
    @KeepForSdk
    @RecentlyNonNull
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zze;
    private long zzf;
    private long zzg;
    private int zzh;
    private long zzi;
    @Nullable
    private volatile String zzj = null;
    @VisibleForTesting
    private zzl zzk;
    @KeepForSdk
    @RecentlyNonNull
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context zzl;
    private final Looper zzm;
    private final GmsClientSupervisor zzn;
    private final GoogleApiAvailabilityLight zzo;
    final Handler zza;
    private final Object zzp = new Object();
    private final Object zzq = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    @Nullable
    private IGmsServiceBroker zzr;
    @VisibleForTesting
    @RecentlyNonNull
    protected ConnectionProgressReportCallbacks zzb;
    @GuardedBy(value="mLock")
    @Nullable
    private T zzs;
    private final ArrayList<zzc<?>> zzt = new ArrayList();
    @GuardedBy(value="mLock")
    @Nullable
    private zzd zzu;
    @GuardedBy(value="mLock")
    private int zzv = 1;
    @Nullable
    private final BaseConnectionCallbacks zzw;
    @Nullable
    private final BaseOnConnectionFailedListener zzx;
    private final int zzy;
    @Nullable
    private final String zzz;
    @Nullable
    private ConnectionResult zzaa = null;
    private boolean zzab = false;
    @Nullable
    private volatile com.google.android.gms.common.internal.zzc zzac = null;
    @VisibleForTesting
    @RecentlyNonNull
    protected AtomicInteger zzc = new AtomicInteger(0);
    @KeepForSdk
    @RecentlyNonNull
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull int n, @RecentlyNonNull BaseConnectionCallbacks baseConnectionCallbacks, @RecentlyNonNull BaseOnConnectionFailedListener baseOnConnectionFailedListener, @RecentlyNonNull String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Looper looper, @RecentlyNonNull GmsClientSupervisor gmsClientSupervisor, @RecentlyNonNull GoogleApiAvailabilityLight googleApiAvailabilityLight, @RecentlyNonNull int n, @Nullable BaseConnectionCallbacks baseConnectionCallbacks, @Nullable BaseOnConnectionFailedListener baseOnConnectionFailedListener, @Nullable String string2) {
        this.zzl = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzm = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzn = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzo = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zza = new zzb(looper);
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(@RecentlyNonNull Context context, @RecentlyNonNull Handler handler, @RecentlyNonNull GmsClientSupervisor gmsClientSupervisor, @RecentlyNonNull GoogleApiAvailabilityLight googleApiAvailabilityLight, @RecentlyNonNull int n, @Nullable BaseConnectionCallbacks baseConnectionCallbacks, @Nullable BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.zzl = Preconditions.checkNotNull(context, "Context must not be null");
        this.zza = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzm = handler.getLooper();
        this.zzn = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzo = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzy = n;
        this.zzw = baseConnectionCallbacks;
        this.zzx = baseOnConnectionFailedListener;
        this.zzz = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    @RecentlyNonNull
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    private final String zza() {
        if (this.zzz == null) {
            return this.zzl.getClass().getName();
        }
        return this.zzz;
    }

    @RecentlyNullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(com.google.android.gms.common.internal.zzc zzc2) {
        this.zzac = zzc2;
    }

    @RecentlyNullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        com.google.android.gms.common.internal.zzc zzc2 = this.zzac;
        if (zzc2 == null) {
            return null;
        }
        return zzc2.zzb;
    }

    @RecentlyNullable
    @KeepForSdk
    public ConnectionTelemetryConfiguration getTelemetryConfiguration() {
        if (this.zzac == null) {
            return null;
        }
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    protected abstract T createServiceInterface(@RecentlyNonNull IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@RecentlyNonNull T t) {
        this.zzg = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(@RecentlyNonNull int n) {
        this.zze = n;
        this.zzf = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(@RecentlyNonNull ConnectionResult connectionResult) {
        this.zzh = connectionResult.getErrorCode();
        this.zzi = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, @Nullable T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.zzp;
        synchronized (object) {
            this.zzv = n;
            this.zzs = t;
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    zzd zzd2 = baseGmsClient.zzu;
                    if (zzd2 != null && baseGmsClient.zzk != null) {
                        String string3 = baseGmsClient.zzk.zza();
                        string2 = baseGmsClient.zzk.zzb();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzn.zza(Preconditions.checkNotNull(baseGmsClient.zzk.zza()), baseGmsClient.zzk.zzb(), baseGmsClient.zzk.zzc(), zzd2, baseGmsClient.zza(), baseGmsClient.zzk.zzd());
                        baseGmsClient.zzc.incrementAndGet();
                    }
                    baseGmsClient.zzu = zzd2 = baseGmsClient.new zzd(baseGmsClient.zzc.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    zzl zzl2 = baseGmsClient.zzk = baseGmsClient2.zzv == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new zzl(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, GmsClientSupervisor.getDefaultBindFlags(), false) : new zzl(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, GmsClientSupervisor.getDefaultBindFlags(), baseGmsClient2.getUseDynamicLookup());
                    if (baseGmsClient.zzk.zzd()) {
                        if (baseGmsClient.getMinApkVersion() < 17895000) {
                            String string4 = String.valueOf(baseGmsClient.zzk.zza());
                            throw new IllegalStateException(string4.length() != 0 ? "Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: ".concat(string4) : new String("Internal Error, the minimum apk version of this BaseGmsClient is too low to support dynamic lookup. Start service action: "));
                        }
                    }
                    boolean bl = baseGmsClient.zzk.zzd();
                    String string5 = baseGmsClient.zza();
                    zzd zzd3 = zzd2;
                    int n2 = baseGmsClient.zzk.zzc();
                    String string6 = baseGmsClient.zzk.zzb();
                    String string7 = Preconditions.checkNotNull(baseGmsClient.zzk.zza());
                    if (baseGmsClient.zzn.zza(new GmsClientSupervisor.zza(string7, string6, n2, bl), zzd3, string5)) break;
                    string2 = baseGmsClient.zzk.zza();
                    String string8 = baseGmsClient.zzk.zzb();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string8).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string8).toString());
                    baseGmsClient.zza(16, null, baseGmsClient.zzc.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked((IInterface)Preconditions.checkNotNull(t));
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    zzd zzd4 = baseGmsClient.zzu;
                    if (zzd4 == null) break;
                    baseGmsClient.zzn.zza(Preconditions.checkNotNull(baseGmsClient.zzk.zza()), baseGmsClient.zzk.zzb(), baseGmsClient.zzk.zzc(), zzd4, baseGmsClient.zza(), baseGmsClient.zzk.zzd());
                    baseGmsClient.zzu = null;
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, @Nullable T t) {
        Object object = this.zzp;
        synchronized (object) {
            if (this.zzv != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzo.isGooglePlayServicesAvailable(this.zzl, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    @KeepForSdk
    public void connect(@RecentlyNonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzb = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public boolean isConnected() {
        Object object = this.zzp;
        synchronized (object) {
            return this.zzv == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public boolean isConnecting() {
        Object object = this.zzp;
        synchronized (object) {
            return this.zzv == 2 || this.zzv == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzb() {
        Object object = this.zzp;
        synchronized (object) {
            return this.zzv == 3;
        }
    }

    @KeepForSdk
    public void disconnect(@RecentlyNonNull String string2) {
        this.zzj = string2;
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void disconnect() {
        this.zzc.incrementAndGet();
        Object object = this.zzt;
        synchronized (object) {
            int n = this.zzt.size();
            for (int i = 0; i < n; ++i) {
                this.zzt.get(i).zze();
            }
            this.zzt.clear();
        }
        object = this.zzq;
        synchronized (object) {
            this.zzr = null;
        }
        this.zza(1, null);
    }

    @KeepForSdk
    @RecentlyNullable
    public String getLastDisconnectMessage() {
        return this.zzj;
    }

    @KeepForSdk
    public void triggerConnectionSuspended(@RecentlyNonNull int n) {
        this.zza.sendMessage(this.zza.obtainMessage(6, this.zzc.get(), n));
    }

    private final void zza(int n) {
        int n2;
        if (this.zzb()) {
            n2 = 5;
            this.zzab = true;
        } else {
            n2 = 4;
        }
        this.zza.sendMessage(this.zza.obtainMessage(n2, this.zzc.get(), 16));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@RecentlyNonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, @RecentlyNonNull int n, @Nullable PendingIntent pendingIntent) {
        this.zzb = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza.sendMessage(this.zza.obtainMessage(3, this.zzc.get(), n, (Object)pendingIntent));
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Context getContext() {
        return this.zzl;
    }

    @KeepForSdk
    @RecentlyNonNull
    public final Looper getLooper() {
        return this.zzm;
    }

    @KeepForSdk
    @RecentlyNullable
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Feature[] getApiFeatures() {
        return zzd;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    @KeepForSdk
    protected void onPostInitHandler(@RecentlyNonNull int n, @Nullable IBinder iBinder, @Nullable Bundle bundle, @RecentlyNonNull int n2) {
        this.zza.sendMessage(this.zza.obtainMessage(1, n2, -1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected final void zza(@RecentlyNonNull int n, @Nullable Bundle bundle, @RecentlyNonNull int n2) {
        this.zza.sendMessage(this.zza.obtainMessage(7, n2, -1, (Object)new zzg(n, null)));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public final T getService() throws DeadObjectException {
        Object object = this.zzp;
        synchronized (object) {
            if (this.zzv == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            return (T)((IInterface)Preconditions.checkNotNull(this.zzs, "Client is connected but service is null"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @RecentlyNonNull Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        Object object = this.zzl.getPackageName();
        GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzy);
        new GetServiceRequest(this.zzy).zza = object;
        object = bundle;
        v0.zzd = object;
        GetServiceRequest getServiceRequest2 = getServiceRequest;
        if (set != null) {
            object = set;
            getServiceRequest2.zzc = object.toArray(new Scope[object.size()]);
        }
        if (this.requiresSignIn()) {
            object = this.getAccount();
            object = object != null ? object : new Account(DEFAULT_ACCOUNT, "com.google");
            getServiceRequest = getServiceRequest2;
            getServiceRequest2.zze = object;
            object = iAccountAccessor;
            if (object != null) {
                getServiceRequest.zzb = object.asBinder();
            }
        } else if (this.requiresAccount()) {
            getServiceRequest2.zze = this.getAccount();
        }
        getServiceRequest2.zzf = zzd;
        getServiceRequest2.zzg = this.getApiFeatures();
        if (this.usesClientTelemetry()) {
            getServiceRequest2.zzh = true;
        }
        try {
            Object object2 = this.zzq;
            synchronized (object2) {
                if (this.zzr != null) {
                    GetServiceRequest getServiceRequest3 = getServiceRequest2;
                    zze zze2 = new zze(this, this.zzc.get());
                    this.zzr.getService(zze2, getServiceRequest3);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(3);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.zzc.get());
            return;
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@RecentlyNonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    @RecentlyNonNull
    protected Set<Scope> getScopes() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void dump(@RecentlyNonNull String string2, @RecentlyNonNull FileDescriptor fileDescriptor, @RecentlyNonNull PrintWriter printWriter, @RecentlyNonNull String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.zzp;
        synchronized (object) {
            n = this.zzv;
            t = this.zzs;
        }
        object = this.zzq;
        synchronized (object) {
            iGmsServiceBroker = this.zzr;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzg > 0L) {
            l = this.zzg;
            string3 = ((DateFormat)object).format(new Date(this.zzg));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzf > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zze) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 3: {
                    printWriter.append("CAUSE_DEAD_OBJECT_EXCEPTION");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zze));
                }
            }
            l = this.zzf;
            string3 = ((DateFormat)object).format(new Date(this.zzf));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzi > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzh));
            l = this.zzi;
            string3 = ((DateFormat)object).format(new Date(this.zzi));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RecentlyNullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzq;
        synchronized (object) {
            if (this.zzr == null) {
                return null;
            }
            return this.zzr.asBinder();
        }
    }

    private final boolean zzc() {
        if (this.zzab) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzk != null) {
            return this.zzk.zzb();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    @KeepForSdk
    @RecentlyNonNull
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected boolean getUseDynamicLookup() {
        return false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean usesClientTelemetry() {
        return false;
    }

    @VisibleForTesting
    public static final class zze
    extends IGmsCallbacks.zza {
        @Nullable
        private BaseGmsClient zza;
        private final int zzb;

        public zze(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zza = baseGmsClient;
            this.zzb = n;
        }

        @Override
        @BinderThread
        public final void zza(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zza, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zza.onPostInitHandler(n, iBinder, bundle, this.zzb);
            this.zza = null;
        }

        @Override
        @BinderThread
        public final void zza(int n, @NonNull IBinder iBinder, @NonNull com.google.android.gms.common.internal.zzc zzc2) {
            BaseGmsClient baseGmsClient = this.zza;
            Preconditions.checkNotNull(baseGmsClient, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(zzc2);
            baseGmsClient.zza(zzc2);
            this.onPostInitComplete(n, iBinder, zzc2.zza);
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        private final int zza;
        @Nullable
        private final Bundle zzb;

        @BinderThread
        protected zza(@Nullable int n, Bundle bundle) {
            super(true);
            this.zza = n;
            this.zzb = bundle;
        }

        protected abstract boolean zza();

        @Override
        protected abstract void zza(ConnectionResult var1);

        @Override
        protected final void zzb() {
        }

        @Override
        protected final /* synthetic */ void zza(Object object) {
            Boolean bl = (Boolean)object;
            zza zza2 = this;
            if (bl == null) {
                zza2.BaseGmsClient.this.zza(1, null);
                return;
            }
            if (zza2.zza == 0) {
                if (!zza2.zza()) {
                    zza2.BaseGmsClient.this.zza(1, null);
                    zza2.zza(new ConnectionResult(8, null));
                    return;
                }
            } else {
                if (zza2.zza == 10) {
                }
                zza2.BaseGmsClient.this.zza(1, null);
                PendingIntent pendingIntent = null;
                if (zza2.zzb != null) {
                    pendingIntent = (PendingIntent)zza2.zzb.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                }
                zza2.zza(new ConnectionResult(zza2.zza, pendingIntent));
            }
        }
    }

    protected final class zzf
    extends zza {
        @Nullable
        private final IBinder zza;

        @BinderThread
        public zzf(@Nullable int n, @Nullable IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zza = iBinder;
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzx != null) {
                BaseGmsClient.this.zzx.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zza() {
            String string2;
            try {
                string2 = Preconditions.checkNotNull(this.zza).getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.zza);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzaa = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzw != null) {
                    BaseGmsClient.this.zzw.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzg
    extends zza {
        @BinderThread
        public zzg(@Nullable int n, Bundle bundle) {
            super(n, null);
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.enableLocalFallback() && BaseGmsClient.this.zzc()) {
                BaseGmsClient.this.zza(16);
                return;
            }
            BaseGmsClient.this.zzb.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zza() {
            BaseGmsClient.this.zzb.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@RecentlyNonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzx != null) {
                BaseGmsClient.this.zzx.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzc<TListener> {
        @Nullable
        private TListener zza;
        private boolean zzb;

        public zzc(TListener TListener) {
            this.zza = TListener;
            this.zzb = false;
        }

        protected abstract void zza(TListener var1);

        protected abstract void zzb();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzc() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.zza;
                if (this.zzb) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zza(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzb();
                    throw runtimeException;
                }
            } else {
                this.zzb();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzb = true;
            }
            this.zzd();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzd() {
            this.zze();
            ArrayList arrayList = BaseGmsClient.this.zzt;
            synchronized (arrayList) {
                BaseGmsClient.this.zzt.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zze() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.zza = null;
                return;
            }
        }
    }

    final class zzb
    extends zzi {
        public zzb(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.zzc.get() != message.arg1) {
                if (com.google.android.gms.common.internal.BaseGmsClient$zzb.zzb(message)) {
                    com.google.android.gms.common.internal.BaseGmsClient$zzb.zza(message);
                }
                return;
            }
            if ((message.what == 1 || message.what == 7 || message.what == 4 && !BaseGmsClient.this.enableLocalFallback() || message.what == 5) && !BaseGmsClient.this.isConnecting()) {
                com.google.android.gms.common.internal.BaseGmsClient$zzb.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzaa = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzc() && !BaseGmsClient.this.zzab) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzaa != null ? BaseGmsClient.this.zzaa : new ConnectionResult(8);
                BaseGmsClient.this.zzb.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzaa != null ? BaseGmsClient.this.zzaa : new ConnectionResult(8);
                BaseGmsClient.this.zzb.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.zzb.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzw != null) {
                    BaseGmsClient.this.zzw.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                com.google.android.gms.common.internal.BaseGmsClient$zzb.zza(message);
                return;
            }
            if (com.google.android.gms.common.internal.BaseGmsClient$zzb.zzb(message)) {
                ((zzc)message.obj).zzc();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzb();
            zzc2.zzd();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@RecentlyNonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        @KeepForSdk
        public void onConnectionFailed(@RecentlyNonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        @RecentlyNonNull
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        @KeepForSdk
        @RecentlyNonNull
        public static final int CAUSE_DEAD_OBJECT_EXCEPTION = 3;

        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(@RecentlyNonNull int var1);
    }

    @VisibleForTesting
    public final class zzd
    implements ServiceConnection {
        private final int zza;

        public zzd(int n) {
            this.zza = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zza(16);
                return;
            }
            Object object = BaseGmsClient.this.zzq;
            synchronized (object) {
                IBinder iBinder2 = iBinder;
                IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.common.internal.IGmsServiceBroker");
                BaseGmsClient.this.zzr = iInterface != null && iInterface instanceof IGmsServiceBroker ? (IGmsServiceBroker)iInterface : new IGmsServiceBroker.Stub.zza(iBinder2);
            }
            BaseGmsClient.this.zza(0, null, this.zza);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzq;
            synchronized (object) {
                BaseGmsClient.this.zzr = null;
            }
            BaseGmsClient.this.zza.sendMessage(BaseGmsClient.this.zza.obtainMessage(6, this.zza, 1));
        }
    }
}

