/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class GmsLogger {
    private static final int zza = 15;
    @Nullable
    private static final String zzb = null;
    private final String zzc;
    @Nullable
    private final String zzd;

    public GmsLogger(@RecentlyNonNull String string2, @Nullable String string3) {
        Preconditions.checkNotNull(string2, "log tag cannot be null");
        Preconditions.checkArgument(string2.length() <= 23, "tag \"%s\" is longer than the %d character maximum", string2, 23);
        this.zzc = string2;
        if (string3 == null || string3.length() <= 0) {
            this.zzd = null;
            return;
        }
        this.zzd = string3;
    }

    public GmsLogger(@RecentlyNonNull String string2) {
        this(string2, null);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean canLog(@RecentlyNonNull int n) {
        return Log.isLoggable((String)this.zzc, (int)n);
    }

    @KeepForSdk
    @RecentlyNonNull
    public final boolean canLogPii() {
        return false;
    }

    @KeepForSdk
    public final void d(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void d(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void v(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void v(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void i(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void i(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void w(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void w(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void wfmt(@RecentlyNonNull String string2, @RecentlyNonNull String string3, Object ... objectArray) {
        if (this.canLog(5)) {
            Log.w((String)this.zzc, (String)this.zza(string3, objectArray));
        }
    }

    @KeepForSdk
    public final void e(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void e(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void efmt(@RecentlyNonNull String string2, @RecentlyNonNull String string3, Object ... objectArray) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3, objectArray));
        }
    }

    @KeepForSdk
    public final void wtf(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(7)) {
            Log.e((String)string2, (String)this.zza(string3), (Throwable)throwable);
            Log.wtf((String)string2, (String)this.zza(string3), (Throwable)throwable);
        }
    }

    @KeepForSdk
    public final void pii(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zza(string3));
        }
    }

    @KeepForSdk
    public final void pii(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLogPii()) {
            String string4 = String.valueOf(string2);
            String string5 = String.valueOf(" PII_LOG");
            Log.i((String)(string5.length() != 0 ? string4.concat(string5) : new String(string4)), (String)this.zza(string3), (Throwable)throwable);
        }
    }

    private final String zza(String string2) {
        if (this.zzd == null) {
            return string2;
        }
        return this.zzd.concat(string2);
    }

    private final String zza(String string2, Object ... objectArray) {
        String string3 = String.format(string2, objectArray);
        if (this.zzd == null) {
            return string3;
        }
        return this.zzd.concat(string3);
    }
}

