/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Context;
import android.os.IBinder;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public abstract class RemoteCreator<T> {
    private final String zza;
    private T zzb;

    @KeepForSdk
    protected RemoteCreator(@RecentlyNonNull String string2) {
        this.zza = string2;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected final T getRemoteCreatorInstance(@RecentlyNonNull Context context) throws RemoteCreatorException {
        if (this.zzb == null) {
            Preconditions.checkNotNull(context);
            Context context2 = GooglePlayServicesUtilLight.getRemoteContext(context);
            if (context2 == null) {
                throw new RemoteCreatorException("Could not get remote context.");
            }
            ClassLoader classLoader = context2.getClassLoader();
            try {
                IBinder iBinder = (IBinder)classLoader.loadClass(this.zza).newInstance();
                this.zzb = this.getRemoteCreator(iBinder);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RemoteCreatorException("Could not load creator class.", classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new RemoteCreatorException("Could not instantiate creator.", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RemoteCreatorException("Could not access creator.", illegalAccessException);
            }
        }
        return this.zzb;
    }

    @KeepForSdk
    @RecentlyNonNull
    protected abstract T getRemoteCreator(@RecentlyNonNull IBinder var1);

    @KeepForSdk
    public static class RemoteCreatorException
    extends Exception {
        public RemoteCreatorException(@RecentlyNonNull String string2) {
            super(string2);
        }

        public RemoteCreatorException(@RecentlyNonNull String string2, @RecentlyNonNull Throwable throwable) {
            super(string2, throwable);
        }
    }
}

