/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.fragment.app.Fragment;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IFragmentWrapper;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;

@KeepForSdk
public final class SupportFragmentWrapper
extends IFragmentWrapper.Stub {
    private Fragment zza;

    @RecentlyNullable
    @KeepForSdk
    public static SupportFragmentWrapper wrap(@Nullable Fragment fragment) {
        if (fragment != null) {
            return new SupportFragmentWrapper(fragment);
        }
        return null;
    }

    private SupportFragmentWrapper(Fragment fragment) {
        this.zza = fragment;
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zza() {
        return ObjectWrapper.wrap(this.zza.getActivity());
    }

    @Override
    @RecentlyNonNull
    public final Bundle zzb() {
        return this.zza.getArguments();
    }

    @Override
    public final int zzc() {
        return this.zza.getId();
    }

    @Override
    @RecentlyNullable
    public final IFragmentWrapper zzd() {
        return SupportFragmentWrapper.wrap(this.zza.getParentFragment());
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zze() {
        return ObjectWrapper.wrap(this.zza.getResources());
    }

    @Override
    public final boolean zzf() {
        return this.zza.getRetainInstance();
    }

    @Override
    @RecentlyNullable
    public final String zzg() {
        return this.zza.getTag();
    }

    @Override
    @RecentlyNullable
    public final IFragmentWrapper zzh() {
        return SupportFragmentWrapper.wrap(this.zza.getTargetFragment());
    }

    @Override
    public final int zzi() {
        return this.zza.getTargetRequestCode();
    }

    @Override
    public final boolean zzj() {
        return this.zza.getUserVisibleHint();
    }

    @Override
    @RecentlyNonNull
    public final IObjectWrapper zzk() {
        return ObjectWrapper.wrap(this.zza.getView());
    }

    @Override
    public final boolean zzl() {
        return this.zza.isAdded();
    }

    @Override
    public final boolean zzm() {
        return this.zza.isDetached();
    }

    @Override
    public final boolean zzn() {
        return this.zza.isHidden();
    }

    @Override
    public final boolean zzo() {
        return this.zza.isInLayout();
    }

    @Override
    public final boolean zzp() {
        return this.zza.isRemoving();
    }

    @Override
    public final boolean zzq() {
        return this.zza.isResumed();
    }

    @Override
    public final boolean zzr() {
        return this.zza.isVisible();
    }

    @Override
    public final void zza(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        View view = (View)ObjectWrapper.unwrap(iObjectWrapper);
        this.zza.registerForContextMenu(Preconditions.checkNotNull(view));
    }

    @Override
    public final void zza(boolean bl) {
        this.zza.setHasOptionsMenu(bl);
    }

    @Override
    public final void zzb(boolean bl) {
        this.zza.setMenuVisibility(bl);
    }

    @Override
    public final void zzc(boolean bl) {
        this.zza.setRetainInstance(bl);
    }

    @Override
    public final void zzd(boolean bl) {
        this.zza.setUserVisibleHint(bl);
    }

    @Override
    public final void zza(@RecentlyNonNull Intent intent) {
        this.zza.startActivity(intent);
    }

    @Override
    public final void zza(@RecentlyNonNull Intent intent, int n) {
        this.zza.startActivityForResult(intent, n);
    }

    @Override
    public final void zzb(@RecentlyNonNull IObjectWrapper iObjectWrapper) {
        View view = (View)ObjectWrapper.unwrap(iObjectWrapper);
        this.zza.unregisterForContextMenu(Preconditions.checkNotNull(view));
    }
}

