/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.wrappers.Wrappers;

@ShowFirstParty
@KeepForSdk
public class GoogleApiAvailabilityLight {
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final String TRACKING_SOURCE_DIALOG = "d";
    @KeepForSdk
    static final String TRACKING_SOURCE_NOTIFICATION = "n";
    private static final GoogleApiAvailabilityLight zza;

    @KeepForSdk
    @RecentlyNonNull
    public static GoogleApiAvailabilityLight getInstance() {
        return zza;
    }

    @KeepForSdk
    GoogleApiAvailabilityLight() {
    }

    @HideFirstParty
    @KeepForSdk
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context) {
        return this.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    @KeepForSdk
    public int isGooglePlayServicesAvailable(@RecentlyNonNull Context context, int n) {
        int n2 = GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, n);
        if (GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, n2)) {
            return 18;
        }
        return n2;
    }

    @KeepForSdk
    public void verifyGooglePlayServicesIsAvailable(@RecentlyNonNull Context context, int n) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        GooglePlayServicesUtilLight.ensurePlayServicesAvailable(context, n);
    }

    @KeepForSdk
    public boolean isUserResolvableError(int n) {
        return GooglePlayServicesUtilLight.isUserRecoverableError(n);
    }

    @Deprecated
    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(int n) {
        return this.getErrorResolutionIntent(null, n, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public Intent getErrorResolutionIntent(@Nullable Context context, int n, @Nullable String string2) {
        switch (n) {
            case 3: {
                return zzs.zza(GOOGLE_PLAY_SERVICES_PACKAGE);
            }
            case 1: 
            case 2: {
                if (context != null) {
                    if (DeviceProperties.isWearableWithoutPlayStore(context)) return zzs.zzc();
                }
                Object object = new StringBuilder();
                ((StringBuilder)object).append("gcore_");
                ((StringBuilder)object).append(GOOGLE_PLAY_SERVICES_VERSION_CODE);
                ((StringBuilder)object).append("-");
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    ((StringBuilder)object).append(string2);
                }
                ((StringBuilder)object).append("-");
                if (context != null) {
                    ((StringBuilder)object).append(context.getPackageName());
                }
                ((StringBuilder)object).append("-");
                if (context == null) return zzs.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                try {
                    ((StringBuilder)object).append(Wrappers.packageManager((Context)context).getPackageInfo((String)context.getPackageName(), (int)0).versionCode);
                    return zzs.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return zzs.zzb(GOOGLE_PLAY_SERVICES_PACKAGE, ((StringBuilder)object).toString());
                }
            }
        }
        return null;
    }

    @RecentlyNullable
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, int n, int n2) {
        return this.getErrorResolutionPendingIntent(context, n, n2, null);
    }

    @RecentlyNullable
    @ShowFirstParty
    @KeepForSdk
    public PendingIntent getErrorResolutionPendingIntent(@RecentlyNonNull Context context, int n, int n2, @Nullable String string2) {
        if ((this = this.getErrorResolutionIntent(context, n, string2)) == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)context, (int)n2, (Intent)this, (int)0x8000000);
    }

    @KeepForSdk
    public void cancelAvailabilityErrorNotifications(@RecentlyNonNull Context context) {
        GooglePlayServicesUtilLight.cancelAvailabilityErrorNotifications(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getClientVersion(@RecentlyNonNull Context context) {
        return GooglePlayServicesUtilLight.getClientVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public int getApkVersion(@RecentlyNonNull Context context) {
        return GooglePlayServicesUtilLight.getApkVersion(context);
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayServicesPossiblyUpdating(@RecentlyNonNull Context context, int n) {
        return GooglePlayServicesUtilLight.isPlayServicesPossiblyUpdating(context, n);
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isPlayStorePossiblyUpdating(@RecentlyNonNull Context context, int n) {
        return GooglePlayServicesUtilLight.isPlayStorePossiblyUpdating(context, n);
    }

    @KeepForSdk
    public boolean isUninstalledAppPossiblyUpdating(@RecentlyNonNull Context context, @RecentlyNonNull String string2) {
        return GooglePlayServicesUtilLight.zza(context, string2);
    }

    @KeepForSdk
    @NonNull
    public String getErrorString(int n) {
        return GooglePlayServicesUtilLight.getErrorString(n);
    }

    static {
        GoogleApiAvailabilityLight googleApiAvailabilityLight;
        GOOGLE_PLAY_SERVICES_VERSION_CODE = GooglePlayServicesUtilLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
        zza = googleApiAvailabilityLight = new GoogleApiAvailabilityLight();
    }
}

