/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.TargetApi;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.UserManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesIncorrectManifestValueException;
import com.google.android.gms.common.GooglePlayServicesMissingManifestValueException;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GoogleSignatureVerifier;
import com.google.android.gms.common.R;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.HideFirstParty;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.internal.zzaf;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.util.zza;
import com.google.android.gms.common.wrappers.Wrappers;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

@ShowFirstParty
@KeepForSdk
public class GooglePlayServicesUtilLight {
    @Deprecated
    @KeepForSdk
    public static final int GOOGLE_PLAY_SERVICES_VERSION_CODE;
    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_SERVICES_PACKAGE = "com.google.android.gms";
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_GAMES_PACKAGE = "com.google.android.play.games";
    @KeepForSdk
    @RecentlyNonNull
    public static final String GOOGLE_PLAY_STORE_PACKAGE = "com.android.vending";
    @KeepForSdk
    static final int GMS_GENERAL_ERROR_NOTIFICATION_ID = 39789;
    @KeepForSdk
    static final int GMS_AVAILABILITY_NOTIFICATION_ID = 10436;
    @VisibleForTesting
    @KeepForSdk
    static final AtomicBoolean sCanceledAvailabilityNotification;
    private static boolean zzb;
    @VisibleForTesting
    static boolean zza;
    private static final AtomicBoolean zzc;

    @ShowFirstParty
    @KeepForSdk
    public static void enableUsingApkIndependentContext() {
        zzc.set(true);
    }

    @KeepForSdk
    GooglePlayServicesUtilLight() {
    }

    @Deprecated
    @VisibleForTesting
    @KeepForSdk
    @NonNull
    public static String getErrorString(int n) {
        return ConnectionResult.zza(n);
    }

    @Deprecated
    @HideFirstParty
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@RecentlyNonNull Context context) {
        return GooglePlayServicesUtilLight.isGooglePlayServicesAvailable(context, GOOGLE_PLAY_SERVICES_VERSION_CODE);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    @KeepForSdk
    public static int isGooglePlayServicesAvailable(@RecentlyNonNull Context object, int n) {
        PackageInfo packageInfo;
        Object object2;
        try {
            Resources resources = object.getResources();
            resources.getString(R.string.common_google_play_services_unknown_issue);
        }
        catch (Throwable throwable) {
            Log.e((String)"GooglePlayServicesUtil", (String)"The Google Play services resources were not found. Check your project configuration to ensure that the resources are included.");
        }
        if (!GOOGLE_PLAY_SERVICES_PACKAGE.equals(object.getPackageName()) && !zzc.get()) {
            int n2 = zzaf.zzb(object);
            if (n2 == 0) {
                object = new GooglePlayServicesMissingManifestValueException();
                throw object;
            }
            if (n2 != GOOGLE_PLAY_SERVICES_VERSION_CODE) {
                object = new GooglePlayServicesIncorrectManifestValueException(n2);
                throw object;
            }
        }
        boolean bl = !DeviceProperties.isWearableWithoutPlayStore(object) ? !DeviceProperties.zzb(object) : false;
        boolean bl2 = n >= 0;
        Preconditions.checkArgument(bl2);
        String string2 = object.getPackageName();
        PackageManager packageManager = object.getPackageManager();
        if (bl) {
            object2 = packageManager.getPackageInfo(GOOGLE_PLAY_STORE_PACKAGE, 8256);
        }
        object2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires Google Play services, but they are missing."));
            return 1;
        }
        GoogleSignatureVerifier.getInstance(object);
        if (!GoogleSignatureVerifier.zzb(packageInfo, true)) {
            Log.w((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires Google Play services, but their signature is invalid."));
            return 9;
        }
        if (bl) {
            Preconditions.checkNotNull(object2);
            if (!GoogleSignatureVerifier.zzb((PackageInfo)object2, true)) {
                Log.w((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires Google Play Store, but its signature is invalid."));
                return 9;
            }
        }
        if (bl && object2 != null && !((PackageInfo)object2).signatures[0].equals((Object)packageInfo.signatures[0])) {
            Log.w((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires Google Play Store, but its signature doesn't match that of Google Play services."));
            return 9;
        }
        if (com.google.android.gms.common.util.zza.zza(packageInfo.versionCode) < com.google.android.gms.common.util.zza.zza(n)) {
            int n3 = packageInfo.versionCode;
            String string3 = String.valueOf(string2);
            int n4 = string3.length();
            object2 = new StringBuilder(n4 + 82);
            ((StringBuilder)object2).append("Google Play services out of date for ");
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append(".  Requires ");
            ((StringBuilder)object2).append(n);
            ((StringBuilder)object2).append(" but found ");
            ((StringBuilder)object2).append(n3);
            Log.w((String)"GooglePlayServicesUtil", (String)((StringBuilder)object2).toString());
            return 2;
        }
        object = packageInfo.applicationInfo;
        if (object == null) {
            object = packageManager.getApplicationInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
        }
        if (object.enabled) return 0;
        return 3;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires the Google Play Store, but it is missing."));
            return 9;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.wtf((String)"GooglePlayServicesUtil", (String)String.valueOf(string2).concat(" requires Google Play services, but they're missing when getting application info."), (Throwable)nameNotFoundException);
            return 1;
        }
    }

    @Deprecated
    @KeepForSdk
    public static void ensurePlayServicesAvailable(@RecentlyNonNull Context object, int n) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        n = GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable((Context)object, n);
        if (n != 0) {
            object = GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent((Context)object, n, "e");
            Serializable serializable = new StringBuilder(57);
            serializable.append("GooglePlayServices not available due to error ");
            serializable.append(n);
            Log.e((String)"GooglePlayServicesUtil", (String)serializable.toString());
            if (object == null) {
                object = new GooglePlayServicesNotAvailableException(n);
                throw object;
            }
            serializable = new GooglePlayServicesRepairableException(n, "Google Play Services not available", (Intent)object);
            throw serializable;
        }
    }

    @Deprecated
    @KeepForSdk
    public static boolean isGooglePlayServicesUid(@RecentlyNonNull Context context, int n) {
        return UidVerifier.isGooglePlayServicesUid(context, n);
    }

    @Deprecated
    @TargetApi(value=19)
    @KeepForSdk
    public static boolean uidHasPackageName(@RecentlyNonNull Context context, int n, @RecentlyNonNull String string2) {
        return UidVerifier.uidHasPackageName(context, n, string2);
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    @RecentlyNullable
    public static Intent getGooglePlayServicesAvailabilityRecoveryIntent(int n) {
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionIntent(null, n, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    @KeepForSdk
    public static boolean honorsDebugCertificates(@RecentlyNonNull Context context) {
        if (!zza) {
            try {
                boolean bl;
                PackageInfo packageInfo = Wrappers.packageManager(context).getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 64);
                GoogleSignatureVerifier.getInstance(context);
                zzb = packageInfo != null && !(bl = GoogleSignatureVerifier.zzb(packageInfo, false)) && (bl = GoogleSignatureVerifier.zzb(packageInfo, true));
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.w((String)"GooglePlayServicesUtil", (String)"Cannot find Google Play services package name.", (Throwable)nameNotFoundException);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if (zzb) return true;
        if (DeviceProperties.isUserBuild()) return false;
        return true;
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNullable
    public static PendingIntent getErrorPendingIntent(int n, @RecentlyNonNull Context context, int n2) {
        return GoogleApiAvailabilityLight.getInstance().getErrorResolutionPendingIntent(context, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    @KeepForSdk
    public static void cancelAvailabilityErrorNotifications(@RecentlyNonNull Context context) {
        if (sCanceledAvailabilityNotification.getAndSet(true)) {
            return;
        }
        try {
            context = (NotificationManager)context.getSystemService("notification");
            if (context == null) return;
        }
        catch (SecurityException securityException) {
            return;
        }
        context.cancel(10436);
    }

    @Deprecated
    @KeepForSdk
    public static boolean isUserRecoverableError(int n) {
        switch (n) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 9: 
        }
        return true;
    }

    @KeepForSdk
    @RecentlyNullable
    public static Resources getRemoteResource(@RecentlyNonNull Context context) {
        try {
            context = context.getPackageManager().getResourcesForApplication(GOOGLE_PLAY_SERVICES_PACKAGE);
            return context;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @KeepForSdk
    @RecentlyNullable
    public static Context getRemoteContext(@RecentlyNonNull Context context) {
        try {
            context = context.createPackageContext(GOOGLE_PLAY_SERVICES_PACKAGE, 3);
            return context;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getClientVersion(@RecentlyNonNull Context context) {
        Preconditions.checkState(true);
        return ClientLibraryUtils.getClientVersion(context, context.getPackageName());
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static int getApkVersion(@RecentlyNonNull Context context) {
        try {
            context = context.getPackageManager().getPackageInfo(GOOGLE_PLAY_SERVICES_PACKAGE, 0);
            return context.versionCode;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.w((String)"GooglePlayServicesUtil", (String)"Google Play services is missing.");
            return 0;
        }
    }

    @Deprecated
    @ShowFirstParty
    @VisibleForTesting
    @KeepForSdk
    public static boolean isSidewinderDevice(@RecentlyNonNull Context context) {
        return DeviceProperties.isSidewinder(context);
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayServicesPossiblyUpdating(@RecentlyNonNull Context context, int n) {
        if (n == 18) {
            return true;
        }
        if (n == 1) {
            return GooglePlayServicesUtilLight.zza(context, GOOGLE_PLAY_SERVICES_PACKAGE);
        }
        return false;
    }

    @Deprecated
    @ShowFirstParty
    @KeepForSdk
    public static boolean isPlayStorePossiblyUpdating(@RecentlyNonNull Context context, int n) {
        if (n == 9) {
            return GooglePlayServicesUtilLight.zza(context, GOOGLE_PLAY_STORE_PACKAGE);
        }
        return false;
    }

    @TargetApi(value=18)
    @KeepForSdk
    public static boolean isRestrictedUserProfile(@RecentlyNonNull Context context) {
        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
            Object object = context.getSystemService("user");
            Preconditions.checkNotNull(object);
            context = ((UserManager)object).getApplicationRestrictions(context.getPackageName());
            if (context != null && "true".equals(context.getString("restricted_profile"))) {
                return true;
            }
        }
        return false;
    }

    static {
        AtomicBoolean atomicBoolean;
        GOOGLE_PLAY_SERVICES_VERSION_CODE = 12451000;
        zzb = false;
        zza = false;
        sCanceledAvailabilityNotification = atomicBoolean = new AtomicBoolean();
        zzc = atomicBoolean = new AtomicBoolean();
    }

    /*
     * Loose catch block
     */
    @TargetApi(value=21)
    static boolean zza(Context context, String string2) {
        block10: {
            block9: {
                Object object;
                boolean bl = string2.equals(GOOGLE_PLAY_SERVICES_PACKAGE);
                if (PlatformVersion.isAtLeastLollipop()) {
                    object = context.getPackageManager().getPackageInstaller().getAllSessions();
                    object = object.iterator();
                    while (object.hasNext()) {
                        if (!string2.equals(((PackageInstaller.SessionInfo)object.next()).getAppPackageName())) continue;
                        return true;
                    }
                }
                object = context.getPackageManager();
                try {
                    string2 = object.getApplicationInfo(string2, 8192);
                    if (!bl) break block9;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
                boolean bl2 = ((ApplicationInfo)string2).enabled;
                return bl2;
            }
            boolean bl = ((ApplicationInfo)string2).enabled;
            if (!bl) break block10;
            boolean bl3 = GooglePlayServicesUtilLight.isRestrictedUserProfile(context);
            if (bl3) break block10;
            return true;
        }
        return false;
        catch (Exception exception) {
            return false;
        }
    }
}

