/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzi;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzl;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzw;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    private final Context zzb;
    private volatile String zzc;

    public GoogleSignatureVerifier(@RecentlyNonNull Context context) {
        this.zzb = context.getApplicationContext();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @RecentlyNonNull
    public static GoogleSignatureVerifier getInstance(@RecentlyNonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (clazz) {
            GoogleSignatureVerifier googleSignatureVerifier = zza;
            if (googleSignatureVerifier != null) return zza;
            zzm.zza(context);
            zza = googleSignatureVerifier = new GoogleSignatureVerifier(context);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int var1_1) {
        var3_3 = this.zzb.getPackageManager().getPackagesForUid(var1_1);
        if (var3_3 == null || (var4_4 = var3_3.length) == 0) {
            this = zzw.zzd("no pkgs");
lbl4:
            // 3 sources

            while (true) {
                this.zzf();
                return this.zza;
            }
        }
        var1_2 = null;
        for (var2_5 = 0; var2_5 < var4_4; ++var2_5) {
            var1_2 = super.zzc(var3_3[var2_5], false, false);
            if (!var1_2.zza) continue;
            this = var1_2;
            ** GOTO lbl4
        }
        Preconditions.checkNotNull(var1_2);
        this = var1_2;
        ** while (true)
    }

    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(@RecentlyNonNull String string2) {
        zzw zzw2 = ((GoogleSignatureVerifier)((Object)zzw2)).zzc(string2, false, false);
        zzw2.zzf();
        return zzw2.zza;
    }

    @KeepForSdk
    public boolean isGooglePublicSignedPackage(@RecentlyNonNull PackageInfo packageInfo) {
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zzb(packageInfo, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzb)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzw zzc(String string2, boolean bl, boolean bl2) {
        zzw zzw2;
        if (string2 == null) {
            return zzw.zzd("null pkg");
        }
        if (string2.equals(((GoogleSignatureVerifier)object).zzc)) return zzw.zzb();
        if (zzm.zzd()) {
            zzw2 = zzm.zzb(string2, GooglePlayServicesUtilLight.honorsDebugCertificates(((GoogleSignatureVerifier)object).zzb), false, false);
        } else {
            zzw2 = ((GoogleSignatureVerifier)object).zzb.getPackageManager().getPackageInfo(string2, 64);
            bl2 = GooglePlayServicesUtilLight.honorsDebugCertificates(((GoogleSignatureVerifier)object).zzb);
            if (zzw2 == null) {
                zzw2 = zzw.zzd("null pkg");
            } else if (((PackageInfo)zzw2).signatures == null || ((PackageInfo)zzw2).signatures.length != 1) {
                zzw2 = zzw.zzd("single cert required");
            } else {
                zzj zzj2 = new zzj(((PackageInfo)zzw2).signatures[0].toByteArray());
                String string3 = ((PackageInfo)zzw2).packageName;
                zzw zzw3 = zzm.zzc(string3, zzj2, bl2, false);
                zzw2 = zzw3.zza ? (((PackageInfo)zzw2).applicationInfo != null ? ((((PackageInfo)zzw2).applicationInfo.flags & 2) != 0 ? (zzm.zzc((String)string3, (zzi)zzj2, (boolean)false, (boolean)true).zza ? zzw.zzd("debuggable release cert app rejected") : zzw3) : zzw3) : zzw3) : zzw3;
            }
        }
        if (!zzw2.zza) return zzw2;
        ((GoogleSignatureVerifier)object).zzc = string2;
        return zzw2;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Object object = "no pkg ";
            if (string2.length() != 0) {
                object = ((String)object).concat(string2);
                return zzw.zze((String)object, nameNotFoundException);
            }
            string2 = new String((String)object);
            object = string2;
            return zzw.zze((String)object, nameNotFoundException);
        }
    }

    @Nullable
    static final zzi zza(PackageInfo packageInfo, zzi ... zziArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzj zzj2 = new zzj(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zziArray.length; ++i) {
            if (!zziArray[i].equals(zzj2)) continue;
            return zziArray[i];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final boolean zzb(@RecentlyNonNull PackageInfo object, boolean bl) {
        if (object != null && object.signatures != null) {
            void var0_2;
            void var1_4;
            if (var1_4 != false) {
                zzi zzi2 = GoogleSignatureVerifier.zza(object, zzl.zza);
            } else {
                zzi[] zziArray = new zzi[]{zzl.zza[0]};
                zzi zzi3 = GoogleSignatureVerifier.zza(object, zziArray);
            }
            if (var0_2 != null) {
                return true;
            }
        }
        return false;
    }
}

