/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @KeepForSdk
    public final void onResult(@RecentlyNonNull R object) {
        Object object2 = object.getStatus();
        if (((Status)object2).isSuccess()) {
            this.onSuccess(object);
            return;
        }
        this.onFailure((Status)object2);
        if (!(object instanceof Releasable)) return;
        try {
            ((Releasable)object).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(object);
            object2 = String.valueOf(string2);
            int n = ((String)object2).length();
            StringBuilder stringBuilder = new StringBuilder(n + 18);
            stringBuilder.append("Unable to release ");
            stringBuilder.append(string2);
            Log.w((String)"ResultCallbacks", (String)stringBuilder.toString(), (Throwable)runtimeException);
            return;
        }
    }

    public abstract void onSuccess(@RecentlyNonNull R var1);

    public abstract void onFailure(@RecentlyNonNull Status var1);
}

