/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.PlatformVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public final class BackgroundDetector
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private static final BackgroundDetector zza;
    private final AtomicBoolean zzb;
    private final AtomicBoolean zzc;
    @GuardedBy(value="sInstance")
    private final ArrayList<BackgroundStateChangeListener> zzd;
    @GuardedBy(value="sInstance")
    private boolean zze;

    @KeepForSdk
    private BackgroundDetector() {
        Serializable serializable;
        this.zzb = serializable = new AtomicBoolean();
        this.zzc = serializable = new AtomicBoolean();
        this.zzd = serializable;
        this.zze = false;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static BackgroundDetector getInstance() {
        return zza;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static void initialize(@RecentlyNonNull Application application) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            boolean bl = BackgroundDetector.zza.zze;
            if (bl) return;
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zza);
            application.registerComponentCallbacks((ComponentCallbacks)zza);
            BackgroundDetector.zza.zze = true;
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @TargetApi(value=16)
    @KeepForSdk
    public boolean readCurrentStateIfPossible(boolean bl) {
        block5: {
            block4: {
                if (this.zzc.get()) break block4;
                if (!PlatformVersion.isAtLeastJellyBean()) break block5;
                ActivityManager.RunningAppProcessInfo runningAppProcessInfo = new ActivityManager.RunningAppProcessInfo();
                ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)runningAppProcessInfo);
                if (!this.zzc.getAndSet(true) && runningAppProcessInfo.importance > 100) {
                    this.zzb.set(true);
                }
            }
            return this.isInBackground();
        }
        return bl;
    }

    @KeepForSdk
    public boolean isInBackground() {
        return this.zzb.get();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public void addListener(@RecentlyNonNull BackgroundStateChangeListener backgroundStateChangeListener) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            this.zzd.add(backgroundStateChangeListener);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void onActivityCreated(@RecentlyNonNull Activity object, @Nullable Bundle bundle) {
        object = this.zzb;
        boolean bl = ((AtomicBoolean)object).compareAndSet(true, false);
        this.zzc.set(true);
        if (bl) {
            this.zza(false);
            return;
        }
    }

    public final void onActivityResumed(@RecentlyNonNull Activity object) {
        object = this.zzb;
        boolean bl = ((AtomicBoolean)object).compareAndSet(true, false);
        this.zzc.set(true);
        if (bl) {
            this.zza(false);
            return;
        }
    }

    public final void onTrimMemory(int n) {
        if (n == 20 && this.zzb.compareAndSet(false, true)) {
            this.zzc.set(true);
            this.zza(true);
            return;
        }
    }

    public final void onActivityStarted(@RecentlyNonNull Activity activity) {
    }

    public final void onActivityPaused(@RecentlyNonNull Activity activity) {
    }

    public final void onActivityStopped(@RecentlyNonNull Activity activity) {
    }

    public final void onActivitySaveInstanceState(@RecentlyNonNull Activity activity, @RecentlyNonNull Bundle bundle) {
    }

    public final void onActivityDestroyed(@RecentlyNonNull Activity activity) {
    }

    public final void onConfigurationChanged(@RecentlyNonNull Configuration configuration) {
    }

    public final void onLowMemory() {
    }

    static {
        BackgroundDetector backgroundDetector;
        zza = backgroundDetector = new BackgroundDetector();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zza(boolean bl) {
        BackgroundDetector backgroundDetector = zza;
        synchronized (backgroundDetector) {
            boolean bl2;
            Iterator<BackgroundStateChangeListener> iterator = ((BackgroundDetector)((Object)iterator)).zzd.iterator();
            while (bl2 = iterator.hasNext()) {
                ((BackgroundStateChangeListener)iterator.next()).onBackgroundStateChanged(bl);
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }
}

