/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.internal.common.zzh;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzd
extends Fragment
implements LifecycleFragment {
    private static final WeakHashMap<FragmentActivity, WeakReference<zzd>> zza;
    private final Map<String, LifecycleCallback> zzb;
    private int zzc;
    @Nullable
    private Bundle zzd;

    public zzd() {
        ArrayMap arrayMap = new ArrayMap();
        this.zzb = Collections.synchronizedMap(arrayMap);
        this.zzc = 0;
    }

    public static zzd zza(FragmentActivity fragmentActivity) {
        WeakReference<zzd> weakReference = zza.get(fragmentActivity);
        if (weakReference == null || (weakReference = (zzd)weakReference.get()) == null) {
            try {
                weakReference = (zzd)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
            }
            catch (ClassCastException classCastException) {
                weakReference = new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", (Throwable)classCastException);
                throw weakReference;
            }
            if (weakReference == null || weakReference.isRemoving()) {
                weakReference = new zzd();
                fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)weakReference, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
            }
            WeakHashMap<FragmentActivity, WeakReference<zzd>> weakHashMap = zza;
            WeakReference<Object> weakReference2 = new WeakReference<Object>(weakReference);
            weakHashMap.put(fragmentActivity, weakReference2);
            return weakReference;
        }
        return weakReference;
    }

    @Override
    @Nullable
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzb.get(string2)));
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback object) {
        if (!((zzd)object2).zzb.containsKey(string2)) {
            ((zzd)object2).zzb.put(string2, (LifecycleCallback)object);
            if (((zzd)object2).zzc > 0) {
                zzh zzh2 = new zzh(Looper.getMainLooper());
                zzc zzc2 = new zzc((zzd)object2, (LifecycleCallback)object, string2);
                zzh2.post(zzc2);
                return;
            }
        } else {
            object = String.valueOf(string2);
            int n = ((String)object).length();
            StringBuilder stringBuilder = new StringBuilder(n + 59);
            stringBuilder.append("LifecycleCallback with tag ");
            stringBuilder.append(string2);
            stringBuilder.append(" already added to this fragment.");
            Object object2 = new IllegalArgumentException(stringBuilder.toString());
            throw object2;
        }
    }

    @Override
    public final boolean isCreated() {
        return this.zzc > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzc >= 2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void onCreate(@Nullable Bundle bundle) {
        void var1_6;
        super.onCreate((Bundle)var1_6);
        this.zzc = 1;
        this.zzd = var1_6;
        Iterator<Map.Entry<String, LifecycleCallback>> iterator = this.zzb.entrySet().iterator();
        while (iterator.hasNext()) {
            void var0_4;
            Map.Entry<String, LifecycleCallback> entry = iterator.next();
            LifecycleCallback lifecycleCallback = entry.getValue();
            if (var1_6 != null) {
                Bundle bundle2 = var1_6.getBundle(entry.getKey());
            } else {
                Object var0_5 = null;
            }
            lifecycleCallback.onCreate((Bundle)var0_4);
        }
        return;
    }

    public final void onStart() {
        super.onStart();
        ((zzd)((Object)iterator)).zzc = 2;
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        ((zzd)((Object)iterator)).zzc = 3;
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onResume();
        }
    }

    public final void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry entry : ((zzd)this).zzb.entrySet()) {
            Bundle bundle2 = new Bundle();
            ((LifecycleCallback)entry.getValue()).onSaveInstanceState(bundle2);
            bundle.putBundle((String)entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        ((zzd)((Object)iterator)).zzc = 4;
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        ((zzd)((Object)iterator)).zzc = 5;
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onDestroy();
        }
    }

    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zzb(zzd zzd2) {
        return zzd2.zzc;
    }

    static /* synthetic */ Bundle zzc(zzd zzd2) {
        return zzd2.zzd;
    }

    static {
        WeakHashMap weakHashMap = new WeakHashMap();
        zza = weakHashMap;
    }
}

