/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;

@KeepForSdk
public final class GmsLogger {
    private final String zza;
    @Nullable
    private final String zzb;

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public GmsLogger(@RecentlyNonNull String string2, @Nullable String string3) {
        Preconditions.checkNotNull(string2, "log tag cannot be null");
        boolean bl = string2.length() <= 23;
        Object[] objectArray = new Object[]{string2, 23};
        Preconditions.checkArgument(bl, "tag \"%s\" is longer than the %d character maximum", objectArray);
        this.zza = string2;
        if (string3 != null && string3.length() > 0) {
            this.zzb = string3;
            return;
        }
        this.zzb = null;
    }

    @KeepForSdk
    public GmsLogger(@RecentlyNonNull String string2) {
        this(string2, null);
    }

    @KeepForSdk
    public boolean canLog(int n) {
        return Log.isLoggable((String)this.zza, (int)n);
    }

    @KeepForSdk
    public boolean canLogPii() {
        return false;
    }

    @KeepForSdk
    public void d(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zza(string3));
            return;
        }
    }

    @KeepForSdk
    public void d(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(3)) {
            Log.d((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void v(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zza(string3));
            return;
        }
    }

    @KeepForSdk
    public void v(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(2)) {
            Log.v((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void i(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zza(string3));
            return;
        }
    }

    @KeepForSdk
    public void i(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(4)) {
            Log.i((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void w(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zza(string3));
            return;
        }
    }

    @KeepForSdk
    public void w(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(5)) {
            Log.w((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void wfmt(@RecentlyNonNull String string2, @RecentlyNonNull String string3, Object ... objectArray) {
        if (this.canLog(5)) {
            Log.w((String)this.zza, (String)this.zzb(string3, objectArray));
            return;
        }
    }

    @KeepForSdk
    public void e(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3));
            return;
        }
    }

    @KeepForSdk
    public void e(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void efmt(@RecentlyNonNull String string2, @RecentlyNonNull String string3, Object ... objectArray) {
        if (this.canLog(6)) {
            Log.e((String)string2, (String)this.zzb(string3, objectArray));
            return;
        }
    }

    @KeepForSdk
    public void wtf(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
        if (this.canLog(7)) {
            Log.e((String)string2, (String)this.zza(string3), (Throwable)throwable);
            Log.wtf((String)string2, (String)this.zza(string3), (Throwable)throwable);
            return;
        }
    }

    @KeepForSdk
    public void pii(@RecentlyNonNull String string2, @RecentlyNonNull String string3) {
    }

    @KeepForSdk
    public void pii(@RecentlyNonNull String string2, @RecentlyNonNull String string3, @RecentlyNonNull Throwable throwable) {
    }

    private final String zza(String string2) {
        String string3 = ((GmsLogger)((Object)string3)).zzb;
        if (string3 == null) {
            return string2;
        }
        return string3.concat(string2);
    }

    private final String zzb(String string2, Object ... objectArray) {
        string2 = String.format(string2, objectArray);
        String string3 = ((GmsLogger)((Object)string3)).zzb;
        if (string3 == null) {
            return string2;
        }
        return string3.concat(string2);
    }
}

