/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;

@KeepForSdk
public final class HexDumpUtils {
    /*
     * Enabled aggressive block sorting
     */
    @RecentlyNullable
    @KeepForSdk
    public static String dump(@RecentlyNonNull byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        if (byArray == null || (n3 = byArray.length) == 0 || n < 0 || n2 <= 0 || n + n2 > n3) {
            return null;
        }
        n3 = bl ? 75 : 57;
        StringBuilder stringBuilder = new StringBuilder(n3 * ((n2 + 15) / 16));
        n3 = 0;
        int n4 = 0;
        int n5 = n2;
        int n6 = n;
        while (n5 > 0) {
            if (n3 == 0) {
                if (n2 < 65536) {
                    Object[] objectArray = new Object[]{n6};
                    stringBuilder.append(String.format("%04X:", objectArray));
                    n4 = n6;
                } else {
                    Object[] objectArray = new Object[]{n6};
                    stringBuilder.append(String.format("%08X:", objectArray));
                    n4 = n6;
                }
            } else if (n3 == 8) {
                stringBuilder.append(" -");
            }
            Object[] objectArray = new Object[]{byArray[n6] & 0xFF};
            stringBuilder.append(String.format(" %02X", objectArray));
            int n7 = n3 + 1;
            if (bl && (n7 == 16 || --n5 == 0)) {
                n3 = 16 - n7;
                if (n3 > 0) {
                    for (int i = 0; i < n3; ++i) {
                        stringBuilder.append("   ");
                    }
                }
                if (n3 >= 8) {
                    stringBuilder.append("  ");
                }
                stringBuilder.append("  ");
                for (int i = 0; i < n7; ++i) {
                    n3 = (char)byArray[n4 + i];
                    if (n3 >= 32) {
                        if (n3 > 126) {
                            n3 = 46;
                        }
                    } else {
                        n3 = 46;
                    }
                    stringBuilder.append((char)n3);
                }
            }
            if (n7 == 16 || n5 == 0) {
                stringBuilder.append('\n');
                n3 = 0;
            } else {
                n3 = n7;
            }
            ++n6;
        }
        return stringBuilder.toString();
    }
}

