/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;

@ShowFirstParty
@KeepForSdk
public class Hex {
    private static final char[] zza;
    private static final char[] zzb;

    @KeepForSdk
    @NonNull
    public static String bytesToStringLowercase(@NonNull byte[] bytes) {
        Object object;
        int n = bytes.length;
        char[] cArray = new char[n + n];
        n = 0;
        for (int i = 0; i < ((byte[])object).length; ++i) {
            int n2 = object[i] & 0xFF;
            int n3 = n + 1;
            char[] cArray2 = zzb;
            cArray[n] = cArray2[n2 >>> 4];
            n = n3 + 1;
            cArray[n3] = cArray2[n2 & 0xF];
        }
        object = new String;
        object(cArray);
        return object;
    }

    @KeepForSdk
    @NonNull
    public static String bytesToStringUppercase(@NonNull byte[] bytes) {
        return Hex.bytesToStringUppercase(bytes, false);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static String bytesToStringUppercase(@NonNull byte[] bytes, boolean zeroTerminated) {
        byte[] byArray;
        void var1_1;
        int n = bytes.length;
        StringBuilder stringBuilder = new StringBuilder(n + n);
        for (int i = 0; i < n && (var1_1 == false || i != n + -1 || (byArray[i] & 0xFF) != 0); ++i) {
            stringBuilder.append(zza[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(zza[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        zza = cArray;
        cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        zzb = cArray;
    }

    @KeepForSdk
    @NonNull
    public static byte[] stringToBytes(@NonNull String hex) throws IllegalArgumentException {
        Object object;
        int n = hex.length();
        if (n % 2 != 0) {
            object = new IllegalArgumentException("Hex string has odd number of characters");
            throw object;
        }
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 + 2;
            byArray[n2 / 2] = (byte)Integer.parseInt(((String)object).substring(n2, n3), 16);
            n2 = n3;
        }
        return byArray;
    }
}

