/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Message;
import android.os.StrictMode;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.zzn;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.PlatformVersion;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;

final class zzo
implements ServiceConnection,
zzs {
    private final Map<ServiceConnection, ServiceConnection> zzb;
    private int zzc;
    private boolean zzd;
    @Nullable
    private IBinder zze;
    private final zzn zzf;
    private ComponentName zzg;
    final /* synthetic */ zzr zza;

    public final int zza() {
        return this.zzc;
    }

    public final ComponentName zzb() {
        return this.zzg;
    }

    @Nullable
    public final IBinder zzc() {
        return this.zze;
    }

    public zzo(zzr hashMap, zzn zzn2) {
        this.zza = hashMap;
        this.zzf = zzn2;
        hashMap = new HashMap<ServiceConnection, ServiceConnection>();
        this.zzb = hashMap;
        this.zzc = 2;
    }

    public final void zzd(ServiceConnection serviceConnection, ServiceConnection serviceConnection2, String string2) {
        this.zzb.put(serviceConnection, serviceConnection2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zze(String string2, @Nullable Executor object) {
        this.zzc = 3;
        StrictMode.VmPolicy vmPolicy = StrictMode.getVmPolicy();
        if (PlatformVersion.isAtLeastS()) {
            StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder(vmPolicy);
            StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.permitUnsafeIntentLaunch().build());
        }
        try {
            boolean bl;
            zzr zzr2 = this.zza;
            ConnectionTracker connectionTracker = zzr.zzg(zzr2);
            Context context = zzr.zze(zzr2);
            zzn zzn2 = this.zzf;
            this.zzd = bl = connectionTracker.zza(context, string2, zzn2.zzc(zzr.zze(zzr2)), this, this.zzf.zza(), (Executor)object);
            if (bl) {
                zzr zzr3 = this.zza;
                zzr3 = zzr.zzf(zzr3);
                object = this.zzf;
                zzr3 = zzr3.obtainMessage(1, object);
                zzr.zzf(this.zza).sendMessageDelayed((Message)zzr3, zzr.zzd(this.zza));
                return;
            }
            this.zzc = 2;
            try {
                zzr zzr4 = this.zza;
                object = zzr.zzg(zzr4);
                ((ConnectionTracker)object).unbindService(zzr.zze(zzr4), this);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
        }
        finally {
            StrictMode.setVmPolicy((StrictMode.VmPolicy)vmPolicy);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        HashMap hashMap = zzr.zzh(this.zza);
        synchronized (hashMap) {
            zzr.zzf(this.zza).removeMessages(1, (Object)this.zzf);
            this.zze = iBinder;
            this.zzg = componentName;
            Iterator<ServiceConnection> iterator = this.zzb.values().iterator();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    this.zzc = 1;
                    return;
                }
                iterator.next().onServiceConnected(componentName, iBinder);
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void onServiceDisconnected(ComponentName componentName) {
        HashMap hashMap = zzr.zzh(this.zza);
        synchronized (hashMap) {
            zzr.zzf(this.zza).removeMessages(1, (Object)this.zzf);
            this.zze = null;
            this.zzg = componentName;
            Iterator<ServiceConnection> iterator = this.zzb.values().iterator();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    this.zzc = 2;
                    return;
                }
                iterator.next().onServiceDisconnected(componentName);
            }
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final void zzf(ServiceConnection serviceConnection, String string2) {
        this.zzb.remove(serviceConnection);
    }

    public final void zzg(String object) {
        zzr.zzf(this.zza).removeMessages(1, (Object)this.zzf);
        object = this.zza;
        zzr.zzg((zzr)object).unbindService(zzr.zze((zzr)object), this);
        this.zzd = false;
        this.zzc = 2;
    }

    public final boolean zzh(ServiceConnection serviceConnection) {
        return this.zzb.containsKey(serviceConnection);
    }

    public final boolean zzi() {
        return this.zzb.isEmpty();
    }

    public final boolean zzj() {
        return this.zzd;
    }
}

