/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.accounts.Account;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.zza;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class AccountPicker {
    @NonNull
    public static Intent newChooseAccountIntent(@NonNull AccountChooserOptions options) {
        AccountChooserOptions accountChooserOptions;
        Intent intent = new Intent();
        AccountChooserOptions.zzD(accountChooserOptions);
        AccountChooserOptions.zze(accountChooserOptions);
        Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
        AccountChooserOptions.zzd(accountChooserOptions);
        Preconditions.checkArgument(true, "Consent is only valid for account chip styled account picker");
        AccountChooserOptions.zzB(accountChooserOptions);
        Preconditions.checkArgument(true, "Making the selected account non-clickable is only supported for the theme THEME_DAY_NIGHT_GOOGLE_MATERIAL2");
        AccountChooserOptions.zzD(accountChooserOptions);
        intent.setAction("com.google.android.gms.common.account.CHOOSE_ACCOUNT");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("allowableAccounts", (Serializable)accountChooserOptions.zzc);
        if (accountChooserOptions.zzd != null) {
            intent.putExtra("allowableAccountTypes", accountChooserOptions.zzd.toArray(new String[0]));
        }
        intent.putExtra("addAccountOptions", accountChooserOptions.zzg);
        intent.putExtra("selectedAccount", (Parcelable)accountChooserOptions.zza);
        AccountChooserOptions.zzB(accountChooserOptions);
        intent.putExtra("selectedAccountIsNotClickable", false);
        intent.putExtra("alwaysPromptForAccount", accountChooserOptions.zze);
        intent.putExtra("descriptionTextOverride", accountChooserOptions.zzf);
        AccountChooserOptions.zzC(accountChooserOptions);
        intent.putExtra("setGmsCoreAccount", false);
        AccountChooserOptions.zzf(accountChooserOptions);
        intent.putExtra("realClientPackage", null);
        AccountChooserOptions.zza(accountChooserOptions);
        intent.putExtra("overrideTheme", 0);
        AccountChooserOptions.zzD(accountChooserOptions);
        intent.putExtra("overrideCustomTheme", 0);
        AccountChooserOptions.zze(accountChooserOptions);
        intent.putExtra("hostedDomainFilter", null);
        Bundle bundle = new Bundle();
        AccountChooserOptions.zzD(accountChooserOptions);
        AccountChooserOptions.zzd(accountChooserOptions);
        AccountChooserOptions.zzz(accountChooserOptions);
        AccountChooserOptions.zzA(accountChooserOptions);
        if (!bundle.isEmpty()) {
            intent.putExtra("first_party_options_bundle", bundle);
        }
        return intent;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @NonNull
    public static Intent newChooseAccountIntent(@Nullable Account selectedAccount, @Nullable ArrayList<Account> allowableAccounts, @Nullable String[] allowableAccountTypes, boolean alwaysPromptForAccount, @Nullable String descriptionOverrideText, @Nullable String addAccountAuthTokenType, @Nullable String[] addAccountRequiredFeatures, @Nullable Bundle addAccountOptions) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        Account account;
        void var7_7;
        void var2_2;
        void var1_1;
        Intent intent = new Intent();
        Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
        intent.setAction("com.google.android.gms.common.account.CHOOSE_ACCOUNT");
        intent.setPackage("com.google.android.gms");
        intent.putExtra("allowableAccounts", (Serializable)var1_1);
        intent.putExtra("allowableAccountTypes", (String[])var2_2);
        intent.putExtra("addAccountOptions", (Bundle)var7_7);
        intent.putExtra("selectedAccount", (Parcelable)account);
        intent.putExtra("alwaysPromptForAccount", (boolean)var3_3);
        intent.putExtra("descriptionTextOverride", (String)var4_4);
        intent.putExtra("authTokenType", (String)var5_5);
        intent.putExtra("addAccountRequiredFeatures", (String[])var6_6);
        intent.putExtra("setGmsCoreAccount", false);
        intent.putExtra("overrideTheme", 0);
        intent.putExtra("overrideCustomTheme", 0);
        intent.putExtra("hostedDomainFilter", null);
        return intent;
    }

    private AccountPicker() {
    }

    public static class AccountChooserOptions {
        @Nullable
        private Account zza;
        private boolean zzb;
        @Nullable
        private ArrayList zzc;
        @Nullable
        private ArrayList zzd;
        private boolean zze;
        @Nullable
        private String zzf;
        @Nullable
        private Bundle zzg;
        private boolean zzh;
        private int zzi;
        @Nullable
        private String zzj;
        private boolean zzk;
        @Nullable
        private zza zzl;
        @Nullable
        private String zzm;
        private boolean zzn;
        private boolean zzo;

        static /* bridge */ /* synthetic */ int zza(AccountChooserOptions accountChooserOptions) {
            int cfr_ignored_0 = accountChooserOptions.zzi;
            return 0;
        }

        static /* bridge */ /* synthetic */ zza zzd(AccountChooserOptions accountChooserOptions) {
            zza cfr_ignored_0 = accountChooserOptions.zzl;
            return null;
        }

        static /* bridge */ /* synthetic */ String zze(AccountChooserOptions accountChooserOptions) {
            String cfr_ignored_0 = accountChooserOptions.zzj;
            return null;
        }

        static /* bridge */ /* synthetic */ String zzf(AccountChooserOptions accountChooserOptions) {
            String cfr_ignored_0 = accountChooserOptions.zzm;
            return null;
        }

        static /* bridge */ /* synthetic */ boolean zzz(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzn;
            return false;
        }

        static /* bridge */ /* synthetic */ boolean zzA(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzo;
            return false;
        }

        static /* bridge */ /* synthetic */ boolean zzB(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzb;
            return false;
        }

        static /* bridge */ /* synthetic */ boolean zzC(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzh;
            return false;
        }

        static /* bridge */ /* synthetic */ boolean zzD(AccountChooserOptions accountChooserOptions) {
            boolean cfr_ignored_0 = accountChooserOptions.zzk;
            return false;
        }

        public static class Builder {
            @Nullable
            private Account zza;
            @Nullable
            private ArrayList zzb;
            @Nullable
            private ArrayList zzc;
            private boolean zzd = false;
            @Nullable
            private String zze;
            @Nullable
            private Bundle zzf;

            /*
             * Enabled aggressive block sorting
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setAllowableAccounts(@Nullable List<Account> allowableAccounts) {
                ArrayList arrayList;
                ArrayList arrayList2;
                arrayList = allowableAccounts == null ? null : (arrayList2 = new ArrayList(arrayList));
                this.zzb = arrayList;
                return this;
            }

            /*
             * Enabled aggressive block sorting
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setAllowableAccountsTypes(@Nullable List<String> allowableAccountTypes) {
                ArrayList arrayList;
                ArrayList arrayList2;
                arrayList = allowableAccountTypes == null ? null : (arrayList2 = new ArrayList(arrayList));
                this.zzc = arrayList;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setAlwaysShowAccountPicker(boolean alwaysShowAccountPicker) {
                void var1_1;
                this.zzd = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setOptionsForAddingAccount(@Nullable Bundle options) {
                void var1_1;
                this.zzf = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setSelectedAccount(@Nullable Account selectedAccount) {
                void var1_1;
                this.zza = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @CanIgnoreReturnValue
            @NonNull
            public Builder setTitleOverrideText(@Nullable String titleOverrideText) {
                void var1_1;
                this.zze = var1_1;
                return this;
            }

            @NonNull
            public AccountChooserOptions build() {
                Preconditions.checkArgument(true, "We only support hostedDomain filter for account chip styled account picker");
                Preconditions.checkArgument(true, "Consent is only valid for account chip styled account picker");
                AccountChooserOptions accountChooserOptions = new AccountChooserOptions();
                accountChooserOptions.zzd = this.zzc;
                accountChooserOptions.zzc = this.zzb;
                accountChooserOptions.zze = this.zzd;
                accountChooserOptions.zzl = null;
                accountChooserOptions.zzj = null;
                accountChooserOptions.zzg = this.zzf;
                accountChooserOptions.zza = this.zza;
                accountChooserOptions.zzb = false;
                accountChooserOptions.zzh = false;
                accountChooserOptions.zzm = null;
                accountChooserOptions.zzi = 0;
                accountChooserOptions.zzf = this.zze;
                accountChooserOptions.zzk = false;
                accountChooserOptions.zzn = false;
                accountChooserOptions.zzo = false;
                return accountChooserOptions;
            }
        }
    }
}

