/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzj;
import com.google.android.gms.common.zzk;
import com.google.android.gms.common.zzm;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzx;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedInheritance;
import java.util.Set;
import javax.annotation.Nullable;

@CheckReturnValue
@RestrictedInheritance(explanation="Sub classing of GMS Core's APIs are restricted to testing fakes.", link="go/gmscore-restrictedinheritance", allowedOnPath=".*java.*/com/google/android/gms/common/testing/.*")
@ShowFirstParty
@KeepForSdk
public class GoogleSignatureVerifier {
    @Nullable
    private static GoogleSignatureVerifier zza;
    @Nullable
    private static volatile Set zzb;
    private final Context zzc;
    private volatile String zzd;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static GoogleSignatureVerifier getInstance(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        Class<GoogleSignatureVerifier> clazz = GoogleSignatureVerifier.class;
        synchronized (clazz) {
            Context context2;
            GoogleSignatureVerifier googleSignatureVerifier = zza;
            if (googleSignatureVerifier != null) return zza;
            zzn.zze(context2);
            zza = new GoogleSignatureVerifier(context2);
            return zza;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public GoogleSignatureVerifier(@NonNull Context context) {
        this.zzc = context.getApplicationContext();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean isGooglePublicSignedPackage(@NonNull PackageInfo packageInfo) {
        void var1_1;
        if (packageInfo == null) {
            return false;
        }
        if (GoogleSignatureVerifier.zzb((PackageInfo)var1_1, false)) {
            return true;
        }
        if (GoogleSignatureVerifier.zzb((PackageInfo)var1_1, true)) {
            if (GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc)) {
                return true;
            }
            Log.w((String)"GoogleSignatureVerifier", (String)"Test-keys aren't accepted on this build.");
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isPackageGoogleSigned(@NonNull String callingPackage) {
        void var1_1;
        zzx zzx2 = this.zzc((String)var1_1, false, false);
        zzx2.zze();
        return zzx2.zza;
    }

    /*
     * Unable to fully structure code
     */
    @ShowFirstParty
    @KeepForSdk
    public boolean isUidGoogleSigned(int uid) {
        var3_3 = this.zzc.getPackageManager().getPackagesForUid((int)var1_1);
        if (var3_3 == null || (var4_4 = var3_3.length) == 0) {
            this = zzx.zzc("no pkgs");
lbl4:
            // 3 sources

            while (true) {
                this.zze();
                return this.zza;
            }
        }
        var1_2 = null;
        for (var2_5 = 0; var2_5 < var4_4; ++var2_5) {
            var1_2 = super.zzc(var3_3[var2_5], false, false);
            if (!var1_2.zza) continue;
            this = var1_2;
            ** GOTO lbl4
        }
        Preconditions.checkNotNull(var1_2);
        this = var1_2;
        ** while (true)
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressLint(value={"PackageManagerGetSignatures"})
    private final zzx zzc(String string2, boolean bl, boolean bl2) {
        zzx zzx2;
        if (string2 == null) {
            return zzx.zzc("null pkg");
        }
        if (string2.equals(this.zzd)) {
            return zzx.zzb();
        }
        if (zzn.zzg()) {
            zzx2 = zzn.zzb(string2, GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc), false, false);
        } else {
            zzx2 = this.zzc.getPackageManager().getPackageInfo(string2, 64);
            bl2 = GooglePlayServicesUtilLight.honorsDebugCertificates(this.zzc);
            if (zzx2 == null) {
                zzx2 = zzx.zzc("null pkg");
            } else if (((PackageInfo)zzx2).signatures == null || ((PackageInfo)zzx2).signatures.length != 1) {
                zzx2 = zzx.zzc("single cert required");
            } else {
                zzk zzk2 = new zzk(((PackageInfo)zzx2).signatures[0].toByteArray());
                String string3 = ((PackageInfo)zzx2).packageName;
                zzx zzx3 = zzn.zza(string3, zzk2, bl2, false);
                zzx2 = zzx3.zza ? (((PackageInfo)zzx2).applicationInfo != null ? ((((PackageInfo)zzx2).applicationInfo.flags & 2) != 0 ? (zzn.zza((String)string3, (zzj)zzk2, (boolean)false, (boolean)true).zza ? zzx.zzc("debuggable release cert app rejected") : zzx3) : zzx3) : zzx3) : zzx3;
            }
        }
        if (zzx2.zza) {
            this.zzd = string2;
        }
        return zzx2;
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return zzx.zzd("no pkg ".concat(string2), nameNotFoundException);
        }
    }

    @Nullable
    static final zzj zza(PackageInfo packageInfo, zzj ... zzjArray) {
        if (packageInfo.signatures == null) {
            return null;
        }
        if (packageInfo.signatures.length != 1) {
            Log.w((String)"GoogleSignatureVerifier", (String)"Package has more than one signature.");
            return null;
        }
        zzk zzk2 = new zzk(packageInfo.signatures[0].toByteArray());
        for (int i = 0; i < zzjArray.length; ++i) {
            if (!zzjArray[i].equals(zzk2)) continue;
            return zzjArray[i];
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static final boolean zzb(@NonNull PackageInfo object, boolean bl) {
        String string2;
        boolean bl2;
        if (bl2 && object != null && ("com.android.vending".equals(object.packageName) || "com.google.android.gms".equals(string2 = object.packageName))) {
            ApplicationInfo applicationInfo = object.applicationInfo;
            bl2 = applicationInfo == null ? false : (applicationInfo.flags & 0x81) != 0;
        }
        if (object != null && object.signatures != null) {
            void var0_2;
            if (bl2) {
                zzj zzj2 = GoogleSignatureVerifier.zza(object, zzm.zza);
            } else {
                zzj zzj3 = GoogleSignatureVerifier.zza(object, new zzj[]{zzm.zza[0]});
            }
            if (var0_2 != null) {
                return true;
            }
        }
        return false;
    }
}

