/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    @NonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";
    private static final GoogleApiAvailabilityLight zza = GoogleApiAvailabilityLight.getInstance();
    private static final Object zzb = new Object();
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzc = null;
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzd = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installIfNeeded(@NonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Context context2;
        Preconditions.checkNotNull(context, "Context must not be null");
        zza.verifyGooglePlayServicesIsAvailable(context2, 11925000);
        Object object = zzb;
        synchronized (object) {
            Object object2;
            block10: {
                block9: {
                    long l = SystemClock.elapsedRealtime();
                    try {
                        object2 = DynamiteModule.load(context2, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite");
                        object2 = ((DynamiteModule)object2).getModuleContext();
                    }
                    catch (DynamiteModule.LoadingException loadingException) {
                        object2 = loadingException.getMessage();
                        Log.w((String)"ProviderInstaller", (String)"Failed to load providerinstaller module: ".concat(String.valueOf(object2)));
                        object2 = null;
                    }
                    if (object2 != null) break block9;
                    long l2 = SystemClock.elapsedRealtime();
                    object2 = GooglePlayServicesUtilLight.getRemoteContext(context2);
                    if (object2 == null) break block10;
                    try {
                        Method method = zzd;
                        if (method == null) {
                            zzd = ProviderInstaller.zzb((Context)object2, "com.google.android.gms.common.security.ProviderInstallerImpl", "reportRequestStats", new Class[]{Context.class, Long.TYPE, Long.TYPE});
                        }
                        zzd.invoke(null, context2, l, l2);
                    }
                    catch (Exception exception) {
                        String string2 = exception.getMessage();
                        Log.w((String)"ProviderInstaller", (String)"Failed to report request stats: ".concat(String.valueOf(string2)));
                    }
                }
                ProviderInstaller.zzc((Context)object2, context2, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                return;
            }
            if (object2 != null) {
                ProviderInstaller.zzc((Context)object2, context2, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void installIfNeededAsync(@NonNull Context context, @NonNull ProviderInstallListener listener) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(var1_1, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context2, (ProviderInstallListener)var1_1).execute(new Void[0]);
    }

    static /* bridge */ /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    private static Method zzb(Context context, String string2, String string3, Class[] classArray) throws ClassNotFoundException, NoSuchMethodException {
        return context.getClassLoader().loadClass(string2).getMethod(string3, classArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="ProviderInstaller.lock")
    private static void zzc(Context context, Context object, String string2) throws GooglePlayServicesNotAvailableException {
        try {
            object = zzc;
            if (object == null) {
                zzc = ProviderInstaller.zzb(context, string2, "insertProvider", new Class[]{Context.class});
            }
            zzc.invoke(null, context);
            return;
        }
        catch (Exception exception) {
            object = exception.getCause();
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                String string3 = object == null ? exception.getMessage() : ((Throwable)object).getMessage();
                object = "Failed to install provider: ";
                string3 = String.valueOf(string3);
                Log.e((String)"ProviderInstaller", (String)((String)object).concat(string3));
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    public static interface ProviderInstallListener {
        public void onProviderInstallFailed(int var1, @Nullable Intent var2);

        public void onProviderInstalled();
    }
}

