/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzac;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzae;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzx;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.RestrictedInheritance;

@CheckReturnValue
@RestrictedInheritance(explanation="Sub classing of GMS Core's APIs are restricted to testing fakes.", link="go/gmscore-restrictedinheritance", allowedOnPath=".*javatests.*/com/google/android/gms/common/.*")
@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzad zzb;
    @VisibleForTesting
    @Nullable
    static volatile zzac zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        void var2_3;
        zzx zzx2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
        PackageSignatureVerifier.zza((Context)zzx2);
        if (!zzn.zzf()) throw new zzae();
        Object object = true != bl ? "-0" : "-1";
        object = String.valueOf(var2_3).concat((String)object);
        if (zza != null && zzac.zzb(zza).equals(object)) {
            return zzac.zza(zza);
        }
        PackageSignatureVerifier.zza((Context)zzx2);
        zzx2 = zzn.zzc((String)var2_3, bl, false, false);
        if (zzx2.zza) {
            int n = zzx2.zzd;
            zza = new zzac((String)object, PackageVerificationResult.zzd((String)var2_3, n));
            return zzac.zza(zza);
        }
        Preconditions.checkNotNull(zzx2.zzb);
        return PackageVerificationResult.zza((String)var2_3, zzx2.zzb, zzx2.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzb();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzc()) return this;
            Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzad zza(Context object) {
        Class<PackageSignatureVerifier> clazz = PackageSignatureVerifier.class;
        synchronized (clazz) {
            zzad zzad2 = zzb;
            if (zzad2 != null) return zzb;
            zzb = new zzad((Context)object);
            return zzb;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

