/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzab;
import com.google.android.gms.common.zzac;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzn;
import com.google.android.gms.common.zzw;

@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzac zzb;
    @VisibleForTesting
    @Nullable
    static volatile zzab zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        void var2_3;
        zzw zzw2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
        PackageSignatureVerifier.zza((Context)zzw2);
        if (!zzn.zzf()) throw new zzad();
        Object object = true != bl ? "-0" : "-1";
        object = String.valueOf(var2_3).concat((String)object);
        if (zza != null && zzab.zzb(zza).equals(object)) {
            return zzab.zza(zza);
        }
        PackageSignatureVerifier.zza((Context)zzw2);
        zzw2 = zzn.zzc((String)var2_3, bl, false, false);
        if (zzw2.zza) {
            int n = zzw2.zzd;
            zza = new zzab((String)object, PackageVerificationResult.zzd((String)var2_3, n));
            return zzab.zza(zza);
        }
        Preconditions.checkNotNull(zzw2.zzb);
        return PackageVerificationResult.zza((String)var2_3, zzw2.zzb, zzw2.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzb();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzc()) return this;
            Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzac zza(Context object) {
        Class<PackageSignatureVerifier> clazz = PackageSignatureVerifier.class;
        synchronized (clazz) {
            zzac zzac2 = zzb;
            if (zzac2 != null) return zzb;
            zzb = new zzac((Context)object);
            return zzb;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

