/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zzb = new Object();
    @Nullable
    private static volatile ConnectionTracker zzc;
    @VisibleForTesting
    @NonNull
    public final ConcurrentHashMap zza = new ConcurrentHashMap();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static ConnectionTracker getInstance() {
        if (zzc == null) {
            Object object = zzb;
            synchronized (object) {
                ConnectionTracker connectionTracker = zzc;
                if (connectionTracker == null) {
                    zzc = new ConnectionTracker();
                }
                {
                    catch (Throwable throwable) {}
                    {
                        throw throwable;
                    }
                }
            }
        }
        ConnectionTracker connectionTracker = zzc;
        Preconditions.checkNotNull(connectionTracker);
        return connectionTracker;
    }

    private ConnectionTracker() {
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void unbindService(@NonNull Context context, @NonNull ServiceConnection conn) {
        void var1_1;
        void var2_2;
        if (ConnectionTracker.zzd(conn) && this.zza.containsKey(var2_2)) {
            try {
                ConnectionTracker.zzb((Context)var1_1, (ServiceConnection)this.zza.get(var2_2));
                this.zza.remove(var2_2);
            }
            catch (Throwable throwable) {
                this.zza.remove(var2_2);
                throw throwable;
            }
            return;
        }
        ConnectionTracker.zzb((Context)var1_1, (ServiceConnection)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public void unbindServiceSafe(@NonNull Context context, @NonNull ServiceConnection conn) {
        try {
            void var2_2;
            void var1_1;
            this.unbindService((Context)var1_1, (ServiceConnection)var2_2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public boolean bindService(@NonNull Context context, @NonNull Intent intent, @NonNull ServiceConnection conn, int flags) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        void v0 = var1_1;
        return this.zzc((Context)v0, v0.getClass().getName(), (Intent)var2_2, (ServiceConnection)var3_3, (int)var4_4, true, null);
    }

    private static void zzb(Context context, ServiceConnection serviceConnection) {
        try {
            context.unbindService(serviceConnection);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException runtimeException) {
            return;
        }
    }

    public final boolean zza(@NonNull Context context, @NonNull String string2, @NonNull Intent intent, @NonNull ServiceConnection serviceConnection, int n, @Nullable Executor executor) {
        return this.zzc(context, string2, intent, serviceConnection, 4225, true, executor);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final boolean zzc(Context var1_2, String var2_4, Intent var3_5, ServiceConnection var4_6, int var5_7, boolean var6_8, @Nullable Executor var7_12) {
        var6_9 /* !! */  = var3_5.getComponent();
        if (var6_9 /* !! */  == null) lbl-1000:
        // 3 sources

        {
            while (true) {
                if (ConnectionTracker.zzd(var4_6)) {
                    block9: {
                        v0 = var4_6;
                        var6_10 = this.zza.putIfAbsent(v0, v0);
                        if (var6_10 != null && var4_6 != var6_10) {
                            var6_10 = new Object[]{var4_6, var2_4, var3_5.getAction()};
                            var2_4 = String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", var6_10);
                            Log.w((String)"ConnectionTracker", (String)var2_4);
                        }
                        var1_3 = ConnectionTracker.zze(var1_2, var3_5, var4_6, var5_7, var7_12);
                        if (!var1_3) break block9;
                        var0_1 = var1_3;
lbl16:
                        // 2 sources

                        return var0_1;
                    }
                    v1 = var4_6;
                    this.zza.remove(v1, v1);
                    return false;
                }
                var0_1 = ConnectionTracker.zze(var1_2, var3_5, var4_6, var5_7, var7_12);
                ** continue;
                break;
            }
        }
        var6_9 /* !! */  = var6_9 /* !! */ .getPackageName();
        "com.google.android.gms".equals(var6_9 /* !! */ );
        try {
            var6_11 = Wrappers.packageManager((Context)var1_2).getApplicationInfo((String)var6_9 /* !! */ , (int)0).flags;
            if ((var6_11 & 0x200000) == 0) ** GOTO lbl-1000
        }
        catch (PackageManager.NameNotFoundException v2) {
            ** continue;
        }
        Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
        return false;
        catch (Throwable v3) {
            v4 = var4_6;
            this.zza.remove(v4, v4);
            throw v3;
        }
    }

    private static boolean zzd(ServiceConnection serviceConnection) {
        return !(serviceConnection instanceof zzt);
    }

    private static final boolean zze(Context context, Intent intent, ServiceConnection serviceConnection, int n, @Nullable Executor executor) {
        if (executor == null) {
            executor = null;
        }
        if (PlatformVersion.isAtLeastQ() && executor != null) {
            return context.bindService(intent, n, executor, serviceConnection);
        }
        return context.bindService(intent, serviceConnection, n);
    }
}

