/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzai;
import com.google.android.gms.common.zzaj;
import com.google.android.gms.common.zzak;
import com.google.android.gms.common.zzq;
import com.google.android.gms.common.zzy;

@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzaj zzb;
    @VisibleForTesting
    @Nullable
    static volatile zzai zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        void var2_3;
        zzad zzad2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
        PackageSignatureVerifier.zza((Context)zzad2);
        if (!zzq.zze()) throw new zzak();
        Object object = true != bl ? "-0" : "-1";
        object = String.valueOf(var2_3).concat((String)object);
        if (zza != null && zzai.zzb(zza).equals(object)) {
            return zzai.zza(zza);
        }
        PackageSignatureVerifier.zza((Context)zzad2);
        zzy zzy2 = new zzy(null);
        zzy2.zzc((String)var2_3);
        zzy2.zza(bl);
        zzy2.zzb(false);
        zzad2 = zzq.zzb(zzy2.zzd());
        if (zzad2.zza) {
            int n = zzad2.zze;
            zza = new zzai((String)object, PackageVerificationResult.zzd((String)var2_3, n));
            return zzai.zza(zza);
        }
        Preconditions.checkNotNull(zzad2.zzb);
        return PackageVerificationResult.zza((String)var2_3, zzad2.zzb, zzad2.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzb();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzc()) return this;
            Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzaj zza(Context object) {
        Class<PackageSignatureVerifier> clazz = PackageSignatureVerifier.class;
        synchronized (clazz) {
            zzaj zzaj2 = zzb;
            if (zzaj2 != null) return zzb;
            zzb = new zzaj((Context)object);
            return zzb;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

