/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.zzaa;
import com.google.android.gms.common.zzae;
import com.google.android.gms.common.zzaf;
import com.google.android.gms.common.zzag;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzx;

@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzaf zzb;
    @VisibleForTesting
    @Nullable
    static volatile zzae zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        void var2_3;
        zzaa zzaa2;
        boolean bl = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
        PackageSignatureVerifier.zza((Context)zzaa2);
        if (!zzo.zze()) throw new zzag();
        Object object = true != bl ? "-0" : "-1";
        String.valueOf(var2_3);
        object = String.valueOf(var2_3).concat((String)object);
        if (zza != null && zza.zza().equals(object)) {
            return zza.zzb();
        }
        PackageSignatureVerifier.zza((Context)zzaa2);
        zzx zzx2 = new zzx(null);
        zzx2.zza((String)var2_3);
        zzx2.zzb(bl);
        zzx2.zzc(false);
        zzaa2 = zzo.zzb(zzx2.zzd());
        if (zzaa2.zza) {
            int n = zzaa2.zze;
            zza = new zzae((String)object, PackageVerificationResult.zzd((String)var2_3, n));
            return zza.zzb();
        }
        String string2 = zzaa2.zzb;
        Preconditions.checkNotNull(string2);
        return PackageVerificationResult.zza((String)var2_3, string2, zzaa2.zzc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzc();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzb()) return this;
            Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
            return this;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static zzaf zza(Context object) {
        Class<PackageSignatureVerifier> clazz = PackageSignatureVerifier.class;
        synchronized (clazz) {
            zzaf zzaf2 = zzb;
            if (zzaf2 != null) return zzb;
            zzb = new zzaf((Context)object);
            return zzb;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }
}

