/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.apps.common.proguard.SideEffectFree;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.util.PlatformVersion;

@KeepForSdk
public final class DeviceProperties {
    @Nullable
    private static Boolean zza;
    @Nullable
    private static Boolean zzb;
    @Nullable
    private static Boolean zzc;
    @Nullable
    private static Boolean zzd;
    @Nullable
    private static Boolean zze;
    @Nullable
    private static Boolean zzf;
    @Nullable
    private static Boolean zzg;
    @Nullable
    private static Boolean zzh;
    @Nullable
    private static Boolean zzi;
    @Nullable
    private static Boolean zzj;
    @Nullable
    private static Boolean zzk;
    @Nullable
    private static Boolean zzl;
    @Nullable
    private static Boolean zzm;
    @Nullable
    private static Boolean zzn;
    @Nullable
    private static Boolean zzo;
    @Nullable
    private static Boolean zzp;
    @Nullable
    private static Boolean zzq;

    private DeviceProperties() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isPhone(@NonNull Context context) {
        block8: {
            boolean bl;
            block7: {
                block9: {
                    block10: {
                        block11: {
                            block12: {
                                block13: {
                                    block14: {
                                        block15: {
                                            block16: {
                                                Context context2;
                                                if (zza != null) break block8;
                                                if (DeviceProperties.isFoldable(context2)) break block9;
                                                if (DeviceProperties.isTablet(context2)) break block10;
                                                if (DeviceProperties.isWearable(context2)) break block11;
                                                if (DeviceProperties.zzd(context2)) break block12;
                                                if (zzk == null) {
                                                    zzk = context2.getPackageManager().hasSystemFeature("org.chromium.arc");
                                                }
                                                if (zzk.booleanValue()) break block13;
                                                if (DeviceProperties.isAuto(context2)) break block14;
                                                if (DeviceProperties.isTv(context2)) break block15;
                                                if (zzn == null) {
                                                    zzn = context2.getPackageManager().hasSystemFeature("com.google.android.feature.AMATI_EXPERIENCE");
                                                }
                                                if (zzn.booleanValue()) break block16;
                                                if (!DeviceProperties.isBstar(context2)) {
                                                    if (!DeviceProperties.isXr(context2)) {
                                                        if (zzq == null) {
                                                            zzq = context2.getPackageManager().hasSystemFeature("com.google.desktop.gms");
                                                        }
                                                        bl = !zzq.booleanValue();
                                                        break block7;
                                                    } else {
                                                        bl = false;
                                                    }
                                                    break block7;
                                                } else {
                                                    bl = false;
                                                }
                                                break block7;
                                            }
                                            bl = false;
                                            break block7;
                                        }
                                        bl = false;
                                        break block7;
                                    }
                                    bl = false;
                                    break block7;
                                }
                                bl = false;
                                break block7;
                            }
                            bl = false;
                            break block7;
                        }
                        bl = false;
                        break block7;
                    }
                    bl = false;
                    break block7;
                }
                bl = true;
            }
            zza = bl;
        }
        return zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isPhoneGo(@NonNull Context context) {
        if (context == null) {
            return false;
        }
        if (zzb == null) {
            boolean bl;
            Context context2;
            if (DeviceProperties.isPhone(context2)) {
                if (zzi == null && (context2 = (ActivityManager)context2.getSystemService("activity")) != null) {
                    zzi = context2.isLowRamDevice();
                }
                bl = Objects.equal(zzi, true) ? Build.VERSION.SDK_INT >= 27 : false;
            } else {
                bl = false;
            }
            zzb = bl;
        }
        return zzb;
    }

    @KeepForSdk
    public static boolean isTablet(@NonNull Context context) {
        return DeviceProperties.isTablet(context.getResources());
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isTablet(@NonNull Resources resources) {
        if (resources == null) {
            return false;
        }
        if (zzc == null) {
            Resources resources2;
            boolean bl = (resources2.getConfiguration().screenLayout & 0xF) > 3 ? true : DeviceProperties.zza(resources2);
            zzc = bl;
        }
        return zzc;
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isFoldable(@NonNull Context context) {
        if (zzd == null) {
            Context context2;
            boolean bl = PlatformVersion.isAtLeastR() ? context2.getPackageManager().hasSystemFeature("android.hardware.sensor.hinge_angle") : false;
            zzd = bl;
        }
        return zzd;
    }

    @KeepForSdk
    public static boolean isSevenInchTablet(@NonNull Context context) {
        return DeviceProperties.zza(context.getResources());
    }

    @TargetApi(value=20)
    @KeepForSdk
    @SideEffectFree
    public static boolean isWearable(@NonNull Context context) {
        return DeviceProperties.zzb(context.getPackageManager());
    }

    @TargetApi(value=26)
    @KeepForSdk
    public static boolean isWearableWithoutPlayStore(@NonNull Context context) {
        Context context2;
        return DeviceProperties.isWearable(context) && !PlatformVersion.isAtLeastN() || DeviceProperties.zzc(context2) && (!PlatformVersion.isAtLeastO() || PlatformVersion.isAtLeastR());
    }

    @TargetApi(value=21)
    @KeepForSdk
    public static boolean isSidewinder(@NonNull Context context) {
        return DeviceProperties.zzc(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    public static boolean isLatchsky(@NonNull Context context) {
        if (zzh == null) {
            Context context2;
            boolean bl = (context2 = context2.getPackageManager()).hasSystemFeature("com.google.android.feature.services_updater") ? context2.hasSystemFeature("cn.google.services") : false;
            zzh = bl;
        }
        return zzh;
    }

    @KeepForSdk
    @SideEffectFree
    public static boolean isAuto(@NonNull Context context) {
        return DeviceProperties.zze(context.getPackageManager());
    }

    @KeepForSdk
    @SideEffectFree
    public static boolean isTv(@NonNull Context context) {
        return DeviceProperties.zzf(context.getPackageManager());
    }

    @KeepForSdk
    @SideEffectFree
    public static boolean isXr(@NonNull Context context) {
        return DeviceProperties.zzg(context.getPackageManager());
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideEffectFree
    @KeepForSdk
    public static boolean isBstar(@NonNull Context context) {
        if (zzo == null) {
            Context context2;
            boolean bl = PlatformVersion.isAtLeastR() ? context2.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE") : false;
            zzo = bl;
        }
        return zzo;
    }

    @KeepForSdk
    public static boolean isUserBuild() {
        return "user".equals(Build.TYPE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean zza(@NonNull Resources resources) {
        if (resources == null) {
            return false;
        }
        if (zze == null) {
            resources = resources.getConfiguration();
            boolean bl = (resources.screenLayout & 0xF) <= 3 ? resources.smallestScreenWidthDp >= 600 : false;
            zze = bl;
        }
        return zze;
    }

    @TargetApi(value=20)
    @SideEffectFree
    public static boolean zzb(@NonNull PackageManager packageManager) {
        if (zzf == null) {
            zzf = packageManager.hasSystemFeature("android.hardware.type.watch");
        }
        return zzf;
    }

    @TargetApi(value=21)
    public static boolean zzc(@NonNull Context context) {
        if (zzg == null) {
            zzg = context.getPackageManager().hasSystemFeature("cn.google");
        }
        return zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean zzd(@NonNull Context context) {
        if (zzj == null) {
            boolean bl = PlatformVersion.isAtLeastO() ? context.getPackageManager().hasSystemFeature("android.hardware.type.embedded") : context.getPackageManager().hasSystemFeature("android.hardware.type.iot");
            zzj = bl;
        }
        return zzj;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideEffectFree
    public static boolean zze(@NonNull PackageManager packageManager) {
        if (zzl == null) {
            boolean bl = PlatformVersion.isAtLeastO() ? packageManager.hasSystemFeature("android.hardware.type.automotive") : false;
            zzl = bl;
        }
        return zzl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SideEffectFree
    public static boolean zzf(@NonNull PackageManager packageManager) {
        if (zzm == null) {
            boolean bl = !packageManager.hasSystemFeature("com.google.android.tv") ? (!packageManager.hasSystemFeature("android.hardware.type.television") ? (!packageManager.hasSystemFeature("android.software.leanback") ? packageManager.hasSystemFeature("com.google.android.feature.AMATI_EXPERIENCE") : true) : true) : true;
            zzm = bl;
        }
        return zzm;
    }

    @SideEffectFree
    public static boolean zzg(@NonNull PackageManager packageManager) {
        if (zzp == null) {
            zzp = packageManager.hasSystemFeature("android.software.xr.api.spatial");
        }
        return zzp;
    }
}

