/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.zzf;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@KeepForSdk
public final class JsonUtils {
    private static final Pattern zza = Pattern.compile("\\\\.");
    private static final Pattern zzb = Pattern.compile("[\\\\\"/\b\f\n\r\t]");

    private JsonUtils() {
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static String unescapeString(@NonNull String text) {
        CharSequence charSequence;
        if (TextUtils.isEmpty((CharSequence)text)) {
            return charSequence;
        }
        String string2 = zzf.zza((String)charSequence);
        Matcher matcher = zza.matcher(string2);
        charSequence = null;
        block10: while (matcher.find()) {
            if (charSequence == null) {
                charSequence = new StringBuffer();
            }
            switch (matcher.group().charAt(1)) {
                case 't': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\t");
                    continue block10;
                }
                case 'r': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\r");
                    continue block10;
                }
                case 'n': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\n");
                    continue block10;
                }
                case 'f': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\f");
                    continue block10;
                }
                case 'b': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\b");
                    continue block10;
                }
                case '\\': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\\\\");
                    continue block10;
                }
                case '/': {
                    matcher.appendReplacement((StringBuffer)charSequence, "/");
                    continue block10;
                }
                case '\"': {
                    matcher.appendReplacement((StringBuffer)charSequence, "\"");
                    continue block10;
                }
                default: {
                    throw new IllegalStateException("Found an escaped character that should never be.");
                }
            }
        }
        if (charSequence == null) {
            return string2;
        }
        matcher.appendTail((StringBuffer)charSequence);
        return ((StringBuffer)charSequence).toString();
    }

    @Nullable
    @KeepForSdk
    public static String escapeString(@Nullable String text) {
        StringBuffer stringBuffer;
        Matcher matcher;
        block16: {
            String string2;
            block15: {
                if (TextUtils.isEmpty((CharSequence)text)) break block15;
                matcher = zzb.matcher(string2);
                stringBuffer = null;
                block10: while (matcher.find()) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    switch (matcher.group().charAt(0)) {
                        default: {
                            continue block10;
                        }
                        case '\\': {
                            matcher.appendReplacement(stringBuffer, "\\\\\\\\");
                            continue block10;
                        }
                        case '/': {
                            matcher.appendReplacement(stringBuffer, "\\\\/");
                            continue block10;
                        }
                        case '\"': {
                            matcher.appendReplacement(stringBuffer, "\\\\\\\"");
                            continue block10;
                        }
                        case '\r': {
                            matcher.appendReplacement(stringBuffer, "\\\\r");
                            continue block10;
                        }
                        case '\f': {
                            matcher.appendReplacement(stringBuffer, "\\\\f");
                            continue block10;
                        }
                        case '\n': {
                            matcher.appendReplacement(stringBuffer, "\\\\n");
                            continue block10;
                        }
                        case '\t': {
                            matcher.appendReplacement(stringBuffer, "\\\\t");
                            continue block10;
                        }
                        case '\b': 
                    }
                    matcher.appendReplacement(stringBuffer, "\\\\b");
                }
                if (stringBuffer != null) break block16;
            }
            return string2;
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    @KeepForSdk
    public static boolean areJsonValuesEquivalent(@Nullable Object a, @Nullable Object b) {
        JSONObject jSONObject;
        if (a != null || jSONObject != null) {
            Object object;
            if (object == null || jSONObject == null) {
                return false;
            }
            if (object instanceof JSONObject && jSONObject instanceof JSONObject) {
                object = (JSONObject)object;
                jSONObject = jSONObject;
                if (object.length() != jSONObject.length()) {
                    return false;
                }
                Iterator iterator = object.keys();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (jSONObject.has(string2)) {
                        Preconditions.checkNotNull(string2);
                        boolean bl = JsonUtils.areJsonValuesEquivalent(object.get(string2), jSONObject.get(string2));
                        if (bl) continue;
                        return false;
                    }
                    return false;
                }
                return true;
            }
            if (object instanceof JSONArray && jSONObject instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                jSONObject = (JSONArray)jSONObject;
                if (jSONArray.length() == jSONObject.length()) {
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        boolean bl = JsonUtils.areJsonValuesEquivalent(jSONArray.get(i), jSONObject.get(i));
                        if (bl) {
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return object.equals(jSONObject);
        }
        return true;
        catch (JSONException jSONException) {
            return false;
        }
        catch (JSONException jSONException) {
            return false;
        }
    }
}

