/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.signin.internal;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.AuthAccountRequest;
import com.google.android.gms.common.internal.BinderWrapper;
import com.google.android.gms.common.internal.ResolveAccountRequest;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import com.google.android.gms.signin.internal.AuthAccountResult;
import com.google.android.gms.signin.internal.CheckServerAuthResult;
import com.google.android.gms.signin.internal.zzd;
import com.google.android.gms.signin.internal.zze;
import com.google.android.gms.signin.internal.zzf;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class zzi
extends zzj<zzf>
implements zzqw {
    private final boolean zzaVl;
    private final com.google.android.gms.common.internal.zzf zzabI;
    private final zzqx zzaaT;
    private Integer zzafj;
    private final ExecutorService zzaVm;

    public zzi(Context context, Looper looper, boolean bl, com.google.android.gms.common.internal.zzf zzf2, zzqx zzqx2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ExecutorService executorService) {
        super(context, looper, 44, zzf2, connectionCallbacks, onConnectionFailedListener);
        this.zzaVl = bl;
        this.zzabI = zzf2;
        this.zzaaT = zzqx2;
        this.zzafj = zzf2.zzoR();
        this.zzaVm = executorService;
    }

    @Override
    public boolean zzlN() {
        return this.zzaVl;
    }

    @Override
    public void zza(zzt zzt2) {
        zzx.zzb(zzt2, (Object)"Expecting a valid IResolveAccountCallbacks");
        try {
            Account account = this.zzabI.zzoI();
            ((zzf)this.zzpc()).zza(new ResolveAccountRequest(account, this.zzafj), zzt2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when resolveAccount is called");
            try {
                zzt2.zzb(new ResolveAccountResponse(8));
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"IResolveAccountCallbacks#onAccountResolutionComplete should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zza(zzp zzp2, boolean bl) {
        try {
            ((zzf)this.zzpc()).zza(zzp2, this.zzafj, bl);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when saveDefaultAccount is called");
        }
    }

    @Override
    public void zzCe() {
        try {
            ((zzf)this.zzpc()).zzjq(this.zzafj);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when clearAccountFromSessionStore is called");
        }
    }

    @Override
    public void zza(zzp zzp2, Set<Scope> set, zze zze2) {
        zzx.zzb(zze2, (Object)"Expecting a valid ISignInCallbacks");
        try {
            ((zzf)this.zzpc()).zza(new AuthAccountRequest(zzp2, set), zze2);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"SignInClientImpl", (String)"Remote service probably died when authAccount is called");
            try {
                zze2.zza(new ConnectionResult(8, null), new AuthAccountResult());
            }
            catch (RemoteException remoteException2) {
                Log.wtf((String)"SignInClientImpl", (String)"ISignInCallbacks#onAuthAccount should be executed from the same process, unexpected RemoteException.", (Throwable)remoteException);
            }
        }
    }

    @Override
    protected String zzfK() {
        return "com.google.android.gms.signin.service.START";
    }

    @Override
    protected String zzfL() {
        return "com.google.android.gms.signin.internal.ISignInService";
    }

    protected zzf zzdO(IBinder iBinder) {
        return zzf.zza.zzdN(iBinder);
    }

    @Override
    protected Bundle zzly() {
        Bundle bundle = zzi.zza(this.zzaaT, this.zzabI.zzoR(), this.zzaVm);
        String string2 = this.zzabI.zzoN();
        if (!this.getContext().getPackageName().equals(string2)) {
            bundle.putString("com.google.android.gms.signin.internal.realClientPackageName", this.zzabI.zzoN());
        }
        return bundle;
    }

    @Override
    public void connect() {
        this.zza(new zzj.zzf(this));
    }

    public static Bundle zza(zzqx zzqx2, Integer n, ExecutorService executorService) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("com.google.android.gms.signin.internal.offlineAccessRequested", zzqx2.zzCf());
        bundle.putBoolean("com.google.android.gms.signin.internal.idTokenRequested", zzqx2.zzlY());
        bundle.putString("com.google.android.gms.signin.internal.serverClientId", zzqx2.zzmb());
        if (zzqx2.zzCg() != null) {
            IBinder iBinder = new zza(zzqx2, executorService).asBinder();
            bundle.putParcelable("com.google.android.gms.signin.internal.signInCallbacks", (Parcelable)new BinderWrapper(iBinder));
        }
        if (n != null) {
            bundle.putInt("com.google.android.gms.common.internal.ClientSettings.sessionId", n.intValue());
        }
        bundle.putBoolean("com.google.android.gms.signin.internal.usePromptModeForAuthCode", zzqx2.zzCh());
        bundle.putBoolean("com.google.android.gms.signin.internal.forceCodeForRefreshToken", zzqx2.zzma());
        return bundle;
    }

    @Override
    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzdO(iBinder);
    }

    private static class zza
    extends zzd.zza {
        private final zzqx zzaaT;
        private final ExecutorService zzaVm;

        public zza(zzqx zzqx2, ExecutorService executorService) {
            this.zzaaT = zzqx2;
            this.zzaVm = executorService;
        }

        @Override
        public void zza(final String string2, final List<Scope> list, final zzf zzf2) throws RemoteException {
            this.zzaVm.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        GoogleApiClient.ServerAuthCodeCallbacks serverAuthCodeCallbacks = zza.this.zzCg();
                        Set<Scope> set = Collections.unmodifiableSet(new HashSet(list));
                        GoogleApiClient.ServerAuthCodeCallbacks.CheckResult checkResult = serverAuthCodeCallbacks.onCheckServerAuthorization(string2, set);
                        CheckServerAuthResult checkServerAuthResult = new CheckServerAuthResult(checkResult.zznD(), checkResult.zznE());
                        zzf2.zza(checkServerAuthResult);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing checkServerAuthorization callback", (Throwable)remoteException);
                    }
                }
            });
        }

        @Override
        public void zza(final String string2, final String string3, final zzf zzf2) throws RemoteException {
            this.zzaVm.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        boolean bl = zza.this.zzCg().onUploadServerAuthCode(string2, string3);
                        zzf2.zzaq(bl);
                    }
                    catch (RemoteException remoteException) {
                        Log.e((String)"SignInClientImpl", (String)"RemoteException thrown when processing uploadServerAuthCode callback", (Throwable)remoteException);
                    }
                }
            });
        }

        private GoogleApiClient.ServerAuthCodeCallbacks zzCg() throws RemoteException {
            return this.zzaaT.zzCg();
        }
    }
}

