/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;

public class AccountChangeEvent
implements SafeParcelable {
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR = new zza();
    final int mVersion;
    final long zzTC;
    final String zzTD;
    final int zzTE;
    final int zzTF;
    final String zzTG;

    AccountChangeEvent(int version, long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = version;
        this.zzTC = id;
        this.zzTD = zzx.zzy(accountName);
        this.zzTE = changeType;
        this.zzTF = eventIndex;
        this.zzTG = changeData;
    }

    public AccountChangeEvent(long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = 1;
        this.zzTC = id;
        this.zzTD = zzx.zzy(accountName);
        this.zzTE = changeType;
        this.zzTF = eventIndex;
        this.zzTG = changeData;
    }

    public String getAccountName() {
        return this.zzTD;
    }

    public int getChangeType() {
        return this.zzTE;
    }

    public int getEventIndex() {
        return this.zzTF;
    }

    public String getChangeData() {
        return this.zzTG;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public String toString() {
        String string2 = "UNKNOWN";
        switch (this.zzTE) {
            case 1: {
                string2 = "ADDED";
                break;
            }
            case 2: {
                string2 = "REMOVED";
                break;
            }
            case 4: {
                string2 = "RENAMED_TO";
                break;
            }
            case 3: {
                string2 = "RENAMED_FROM";
            }
        }
        return "AccountChangeEvent {accountName = " + this.zzTD + ", changeType = " + string2 + ", changeData = " + this.zzTG + ", eventIndex = " + this.zzTF + "}";
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersion, this.zzTC, this.zzTD, this.zzTE, this.zzTF, this.zzTG);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof AccountChangeEvent) {
            AccountChangeEvent accountChangeEvent = (AccountChangeEvent)that;
            return this.mVersion == accountChangeEvent.mVersion && this.zzTC == accountChangeEvent.zzTC && zzw.equal(this.zzTD, accountChangeEvent.zzTD) && this.zzTE == accountChangeEvent.zzTE && this.zzTF == accountChangeEvent.zzTF && zzw.equal(this.zzTG, accountChangeEvent.zzTG);
        }
        return false;
    }
}

