/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zztk;
import com.google.android.gms.internal.zztn;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zztd {
    private final ByteBuffer zzbpP;

    private zztd(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zztd(ByteBuffer byteBuffer) {
        this.zzbpP = byteBuffer;
        this.zzbpP.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zztd zzD(byte[] byArray) {
        return zztd.zzb(byArray, 0, byArray.length);
    }

    public static zztd zzb(byte[] byArray, int n, int n2) {
        return new zztd(byArray, n, n2);
    }

    public void zza(int n, double d) throws IOException {
        this.zzK(n, 1);
        this.zzk(d);
    }

    public void zzb(int n, float f) throws IOException {
        this.zzK(n, 5);
        this.zzi(f);
    }

    public void zzb(int n, long l) throws IOException {
        this.zzK(n, 0);
        this.zzab(l);
    }

    public void zzG(int n, int n2) throws IOException {
        this.zzK(n, 0);
        this.zzms(n2);
    }

    public void zzb(int n, boolean bl) throws IOException {
        this.zzK(n, 0);
        this.zzax(bl);
    }

    public void zzb(int n, String string2) throws IOException {
        this.zzK(n, 2);
        this.zzfZ(string2);
    }

    public void zza(int n, zztk zztk2) throws IOException {
        this.zzK(n, 2);
        this.zzc(zztk2);
    }

    public void zza(int n, byte[] byArray) throws IOException {
        this.zzK(n, 2);
        this.zzE(byArray);
    }

    public void zzH(int n, int n2) throws IOException {
        this.zzK(n, 0);
        this.zzmt(n2);
    }

    public void zzc(int n, long l) throws IOException {
        this.zzK(n, 0);
        this.zzac(l);
    }

    public void zzk(double d) throws IOException {
        this.zzah(Double.doubleToLongBits(d));
    }

    public void zzi(float f) throws IOException {
        this.zzmA(Float.floatToIntBits(f));
    }

    public void zzab(long l) throws IOException {
        this.zzaf(l);
    }

    public void zzms(int n) throws IOException {
        if (n >= 0) {
            this.zzmy(n);
        } else {
            this.zzaf(n);
        }
    }

    public void zzax(boolean bl) throws IOException {
        this.zzmw(bl ? 1 : 0);
    }

    public void zzfZ(String string2) throws IOException {
        try {
            int n = zztd.zzmz(string2.length());
            int n2 = zztd.zzmz(string2.length() * 3);
            if (n == n2) {
                int n3 = this.zzbpP.position();
                if (this.zzbpP.remaining() < n) {
                    throw new zza(n3 + n, this.zzbpP.limit());
                }
                this.zzbpP.position(n3 + n);
                zztd.zza((CharSequence)string2, this.zzbpP);
                int n4 = this.zzbpP.position();
                this.zzbpP.position(n3);
                this.zzmy(n4 - n3 - n);
                this.zzbpP.position(n4);
            } else {
                this.zzmy(zztd.zzc(string2));
                zztd.zza((CharSequence)string2, this.zzbpP);
            }
        }
        catch (BufferOverflowException bufferOverflowException) {
            zza zza2 = new zza(this.zzbpP.position(), this.zzbpP.limit());
            zza2.initCause(bufferOverflowException);
            throw zza2;
        }
    }

    private static int zzc(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                n3 += zztd.zza(charSequence, n);
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("UTF-8 length does not fit in int: " + ((long)n3 + 0x100000000L));
        }
        return n3;
    }

    private static int zza(CharSequence charSequence, int n) {
        int n2 = charSequence.length();
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
                continue;
            }
            n3 += 2;
            if ('\ud800' > c || c > '\udfff') continue;
            int n4 = Character.codePointAt(charSequence, i);
            if (n4 < 65536) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + i);
            }
            ++i;
        }
        return n3;
    }

    private static void zza(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n = zztd.zza(charSequence, byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                byteBuffer.position(n - byteBuffer.arrayOffset());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        } else {
            zztd.zzb(charSequence, byteBuffer);
        }
    }

    private static void zzb(CharSequence charSequence, ByteBuffer byteBuffer) {
        int n = charSequence.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 < '\u0080') {
                byteBuffer.put((byte)c2);
                continue;
            }
            if (c2 < '\u0800') {
                byteBuffer.put((byte)(0x3C0 | c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (c2 < '\ud800' || '\udfff' < c2) {
                byteBuffer.put((byte)(0x1E0 | c2 >>> 12));
                byteBuffer.put((byte)(0x80 | 0x3F & c2 >>> 6));
                byteBuffer.put((byte)(0x80 | 0x3F & c2));
                continue;
            }
            if (i + 1 == charSequence.length() || !Character.isSurrogatePair(c2, c = charSequence.charAt(++i))) {
                throw new IllegalArgumentException("Unpaired surrogate at index " + (i - 1));
            }
            int n2 = Character.toCodePoint(c2, c);
            byteBuffer.put((byte)(0xF0 | n2 >>> 18));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 12));
            byteBuffer.put((byte)(0x80 | 0x3F & n2 >>> 6));
            byteBuffer.put((byte)(0x80 | 0x3F & n2));
        }
    }

    private static int zza(CharSequence charSequence, byte[] byArray, int n, int n2) {
        char c;
        int n3;
        int n4 = charSequence.length();
        int n5 = n;
        int n6 = n + n2;
        for (n3 = 0; n3 < n4 && n3 + n5 < n6 && (c = charSequence.charAt(n3)) < '\u0080'; ++n3) {
            byArray[n5 + n3] = (byte)c;
        }
        if (n3 == n4) {
            return n5 + n4;
        }
        n5 += n3;
        while (n3 < n4) {
            c = charSequence.charAt(n3);
            if (c < '\u0080' && n5 < n6) {
                byArray[n5++] = (byte)c;
            } else if (c < '\u0800' && n5 <= n6 - 2) {
                byArray[n5++] = (byte)(0x3C0 | c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if ((c < '\ud800' || '\udfff' < c) && n5 <= n6 - 3) {
                byArray[n5++] = (byte)(0x1E0 | c >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & c >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & c);
            } else if (n5 <= n6 - 4) {
                char c2;
                if (n3 + 1 == charSequence.length() || !Character.isSurrogatePair(c, c2 = charSequence.charAt(++n3))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + (n3 - 1));
                }
                int n7 = Character.toCodePoint(c, c2);
                byArray[n5++] = (byte)(0xF0 | n7 >>> 18);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 12);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7 >>> 6);
                byArray[n5++] = (byte)(0x80 | 0x3F & n7);
            } else {
                if (!('\ud800' > c || c > '\udfff' || n3 + 1 != charSequence.length() && Character.isSurrogatePair(c, charSequence.charAt(n3 + 1)))) {
                    throw new IllegalArgumentException("Unpaired surrogate at index " + n3);
                }
                throw new ArrayIndexOutOfBoundsException("Failed writing " + c + " at index " + n5);
            }
            ++n3;
        }
        return n5;
    }

    public void zzb(zztk zztk2) throws IOException {
        zztk2.writeTo(this);
    }

    public void zzc(zztk zztk2) throws IOException {
        this.zzmy(zztk2.getCachedSize());
        zztk2.writeTo(this);
    }

    public void zzE(byte[] byArray) throws IOException {
        this.zzmy(byArray.length);
        this.zzG(byArray);
    }

    public void zzmt(int n) throws IOException {
        this.zzmy(zztd.zzmB(n));
    }

    public void zzac(long l) throws IOException {
        this.zzaf(zztd.zzai(l));
    }

    public static int zzb(int n, double d) {
        return zztd.zzmx(n) + zztd.zzl(d);
    }

    public static int zzc(int n, float f) {
        return zztd.zzmx(n) + zztd.zzj(f);
    }

    public static int zzd(int n, long l) {
        return zztd.zzmx(n) + zztd.zzad(l);
    }

    public static int zzI(int n, int n2) {
        return zztd.zzmx(n) + zztd.zzmu(n2);
    }

    public static int zzc(int n, boolean bl) {
        return zztd.zzmx(n) + zztd.zzay(bl);
    }

    public static int zzp(int n, String string2) {
        return zztd.zzmx(n) + zztd.zzga(string2);
    }

    public static int zzb(int n, zztk zztk2) {
        return zztd.zzmx(n) * 2 + zztd.zzd(zztk2);
    }

    public static int zzc(int n, zztk zztk2) {
        return zztd.zzmx(n) + zztd.zze(zztk2);
    }

    public static int zzb(int n, byte[] byArray) {
        return zztd.zzmx(n) + zztd.zzF(byArray);
    }

    public static int zzJ(int n, int n2) {
        return zztd.zzmx(n) + zztd.zzmv(n2);
    }

    public static int zze(int n, long l) {
        return zztd.zzmx(n) + zztd.zzae(l);
    }

    public static int zzl(double d) {
        return 8;
    }

    public static int zzj(float f) {
        return 4;
    }

    public static int zzad(long l) {
        return zztd.zzag(l);
    }

    public static int zzmu(int n) {
        if (n >= 0) {
            return zztd.zzmz(n);
        }
        return 10;
    }

    public static int zzay(boolean bl) {
        return 1;
    }

    public static int zzga(String string2) {
        int n = zztd.zzc(string2);
        return zztd.zzmz(n) + n;
    }

    public static int zzd(zztk zztk2) {
        return zztk2.getSerializedSize();
    }

    public static int zze(zztk zztk2) {
        int n = zztk2.getSerializedSize();
        return zztd.zzmz(n) + n;
    }

    public static int zzF(byte[] byArray) {
        return zztd.zzmz(byArray.length) + byArray.length;
    }

    public static int zzmv(int n) {
        return zztd.zzmz(zztd.zzmB(n));
    }

    public static int zzae(long l) {
        return zztd.zzag(zztd.zzai(l));
    }

    public int zzHx() {
        return this.zzbpP.remaining();
    }

    public void zzHy() {
        if (this.zzHx() != 0) {
            throw new IllegalStateException("Did not write as much data as expected.");
        }
    }

    public void zzb(byte by) throws IOException {
        if (!this.zzbpP.hasRemaining()) {
            throw new zza(this.zzbpP.position(), this.zzbpP.limit());
        }
        this.zzbpP.put(by);
    }

    public void zzmw(int n) throws IOException {
        this.zzb((byte)n);
    }

    public void zzG(byte[] byArray) throws IOException {
        this.zzc(byArray, 0, byArray.length);
    }

    public void zzc(byte[] byArray, int n, int n2) throws IOException {
        if (this.zzbpP.remaining() < n2) {
            throw new zza(this.zzbpP.position(), this.zzbpP.limit());
        }
        this.zzbpP.put(byArray, n, n2);
    }

    public void zzK(int n, int n2) throws IOException {
        this.zzmy(zztn.zzL(n, n2));
    }

    public static int zzmx(int n) {
        return zztd.zzmz(zztn.zzL(n, 0));
    }

    public void zzmy(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzmw(n);
                return;
            }
            this.zzmw(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzmz(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public void zzaf(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzmw((int)l);
                return;
            }
            this.zzmw((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }

    public static int zzag(long l) {
        if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((l & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((l & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((l & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((l & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((l & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((l & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    public void zzmA(int n) throws IOException {
        if (this.zzbpP.remaining() < 4) {
            throw new zza(this.zzbpP.position(), this.zzbpP.limit());
        }
        this.zzbpP.putInt(n);
    }

    public void zzah(long l) throws IOException {
        if (this.zzbpP.remaining() < 8) {
            throw new zza(this.zzbpP.position(), this.zzbpP.limit());
        }
        this.zzbpP.putLong(l);
    }

    public static int zzmB(int n) {
        return n << 1 ^ n >> 31;
    }

    public static long zzai(long l) {
        return l << 1 ^ l >> 63;
    }

    public static class zza
    extends IOException {
        zza(int n, int n2) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space (pos " + n + " limit " + n2 + ").");
        }
    }
}

