/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Patterns;
import com.google.android.gms.auth.api.signin.internal.zze;
import com.google.android.gms.auth.api.signin.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import org.json.JSONException;
import org.json.JSONObject;

public class EmailSignInOptions
implements SafeParcelable {
    public static final Parcelable.Creator<EmailSignInOptions> CREATOR = new zza();
    final int versionCode;
    private final Uri zzWL;
    private String zzWM;
    private Uri zzWN;

    EmailSignInOptions(int versionCode, Uri serverWidgetUrl, String modeQueryName, Uri tosUrl) {
        zzx.zzb(serverWidgetUrl, (Object)"Server widget url cannot be null in order to use email/password sign in.");
        zzx.zzh(serverWidgetUrl.toString(), "Server widget url cannot be null in order to use email/password sign in.");
        zzx.zzb(Patterns.WEB_URL.matcher(serverWidgetUrl.toString()).matches(), (Object)"Invalid server widget url");
        this.versionCode = versionCode;
        this.zzWL = serverWidgetUrl;
        this.zzWM = modeQueryName;
        this.zzWN = tosUrl;
    }

    public Uri zzmF() {
        return this.zzWL;
    }

    public Uri zzmG() {
        return this.zzWN;
    }

    public String zzmH() {
        return this.zzWM;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            EmailSignInOptions emailSignInOptions = (EmailSignInOptions)obj;
            return this.zzWL.equals((Object)emailSignInOptions.zzmF()) && (this.zzWN == null ? emailSignInOptions.zzmG() == null : this.zzWN.equals((Object)emailSignInOptions.zzmG())) && (TextUtils.isEmpty((CharSequence)this.zzWM) ? TextUtils.isEmpty((CharSequence)emailSignInOptions.zzmH()) : this.zzWM.equals(emailSignInOptions.zzmH()));
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return new zze().zzp(this.zzWL).zzp(this.zzWN).zzp(this.zzWM).zzne();
    }

    public String zzmI() {
        return this.zzmJ().toString();
    }

    private JSONObject zzmJ() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("serverWidgetUrl", (Object)this.zzWL.toString());
            if (!TextUtils.isEmpty((CharSequence)this.zzWM)) {
                jSONObject.put("modeQueryName", (Object)this.zzWM);
            }
            if (this.zzWN != null) {
                jSONObject.put("tosUrl", (Object)this.zzWN.toString());
            }
            return jSONObject;
        }
        catch (JSONException jSONException) {
            throw new RuntimeException(jSONException);
        }
    }
}

