/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;

public final class Status
implements Result,
SafeParcelable {
    public static final Status zzagC = new Status(0);
    public static final Status zzagD = new Status(14);
    public static final Status zzagE = new Status(8);
    public static final Status zzagF = new Status(15);
    public static final Status zzagG = new Status(16);
    public static final Parcelable.Creator<Status> CREATOR = new zzc();
    private final int mVersionCode;
    private final int zzade;
    private final String zzafC;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.mVersionCode = versionCode;
        this.zzade = statusCode;
        this.zzafC = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(statusCode, null);
    }

    public Status(int statusCode, String statusMessage) {
        this(1, statusCode, statusMessage, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent zzpc() {
        return this.mPendingIntent;
    }

    public String getStatusMessage() {
        return this.zzafC;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.zzade <= 0;
    }

    public boolean isCanceled() {
        return this.zzade == 16;
    }

    public boolean isInterrupted() {
        return this.zzade == 14;
    }

    public int getStatusCode() {
        return this.zzade;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersionCode, this.zzade, this.zzafC, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.mVersionCode == status.mVersionCode && this.zzade == status.zzade && zzw.equal(this.zzafC, status.zzafC) && zzw.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzpd() {
        if (this.zzafC != null) {
            return this.zzafC;
        }
        return CommonStatusCodes.getStatusCodeString(this.zzade);
    }

    public String toString() {
        return zzw.zzy(this).zzg("statusCode", this.zzpd()).zzg("resolution", this.mPendingIntent).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

