/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzq;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class zzb<R extends Result>
extends PendingResult<R> {
    private final Object zzagI = new Object();
    protected final zza<R> zzagJ;
    private final WeakReference<GoogleApiClient> zzagK;
    private final CountDownLatch zzpJ = new CountDownLatch(1);
    private final ArrayList<PendingResult.zza> zzagL = new ArrayList();
    private ResultCallback<? super R> zzagM;
    private volatile R zzagy;
    private volatile boolean zzagN;
    private boolean zzL;
    private boolean zzagO;
    private boolean zzagP;
    private zzq zzagQ;
    private Integer zzagR;
    private volatile zzx<R> zzagS;

    protected zzb(GoogleApiClient googleApiClient) {
        Looper looper = googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper();
        this.zzagJ = new zza(looper);
        this.zzagK = new WeakReference<GoogleApiClient>(googleApiClient);
    }

    @Deprecated
    protected zzb(Looper looper) {
        this.zzagJ = new zza(looper);
        this.zzagK = new WeakReference<Object>(null);
    }

    public final boolean isReady() {
        return this.zzpJ.getCount() == 0L;
    }

    @Override
    public final R await() {
        com.google.android.gms.common.internal.zzx.zza(Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread");
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed");
        com.google.android.gms.common.internal.zzx.zza(this.zzagS == null, (Object)"Cannot await if then() has been called.");
        try {
            this.zzpJ.await();
        }
        catch (InterruptedException interruptedException) {
            this.zzx(Status.zzagD);
        }
        com.google.android.gms.common.internal.zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    @Override
    public final R await(long time, TimeUnit units) {
        com.google.android.gms.common.internal.zzx.zza(time <= 0L || Looper.myLooper() != Looper.getMainLooper(), (Object)"await must not be called on the UI thread when time is greater than zero.");
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
        com.google.android.gms.common.internal.zzx.zza(this.zzagS == null, (Object)"Cannot await if then() has been called.");
        try {
            boolean bl = this.zzpJ.await(time, units);
            if (!bl) {
                this.zzx(Status.zzagF);
            }
        }
        catch (InterruptedException interruptedException) {
            this.zzx(Status.zzagD);
        }
        com.google.android.gms.common.internal.zzx.zza(this.isReady(), (Object)"Result is not ready.");
        return this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback) {
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
        Object object = this.zzagI;
        synchronized (object) {
            GoogleApiClient googleApiClient;
            com.google.android.gms.common.internal.zzx.zza(this.zzagS == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.zzagP && ((googleApiClient = (GoogleApiClient)this.zzagK.get()) == null || !(callback instanceof zzx))) {
                this.cancel();
                return;
            }
            if (this.isReady()) {
                this.zzagJ.zza(callback, (R)this.get());
            } else {
                this.zzagM = callback;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setResultCallback(ResultCallback<? super R> callback, long time, TimeUnit units) {
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
        Object object = this.zzagI;
        synchronized (object) {
            GoogleApiClient googleApiClient;
            com.google.android.gms.common.internal.zzx.zza(this.zzagS == null, (Object)"Cannot set callbacks if then() has been called.");
            if (this.isCanceled()) {
                return;
            }
            if (this.zzagP && ((googleApiClient = (GoogleApiClient)this.zzagK.get()) == null || !(callback instanceof zzx))) {
                this.cancel();
                return;
            }
            if (this.isReady()) {
                this.zzagJ.zza(callback, (R)this.get());
            } else {
                this.zzagM = callback;
                this.zzagJ.zza(this, units.toMillis(time));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(PendingResult.zza zza2) {
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
        com.google.android.gms.common.internal.zzx.zzb(zza2 != null, (Object)"Callback cannot be null.");
        Object object = this.zzagI;
        synchronized (object) {
            if (this.isReady()) {
                zza2.zzu(this.zzagy.getStatus());
            } else {
                this.zzagL.add(zza2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.zzagI;
        synchronized (object) {
            if (this.zzL || this.zzagN) {
                return;
            }
            if (this.zzagQ != null) {
                try {
                    this.zzagQ.cancel();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            zzb.zzc(this.zzagy);
            this.zzagM = null;
            this.zzL = true;
            this.zzb(this.zzc(Status.zzagG));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzpg() {
        Object object = this.zzagI;
        synchronized (object) {
            GoogleApiClient googleApiClient = (GoogleApiClient)this.zzagK.get();
            if (googleApiClient == null) {
                this.cancel();
                return;
            }
            if (this.zzagM == null || this.zzagM instanceof zzx) {
                this.zzagP = true;
            } else {
                this.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCanceled() {
        Object object = this.zzagI;
        synchronized (object) {
            return this.zzL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S extends Result> TransformedResult<S> then(ResultTransform<? super R, ? extends S> transform) {
        com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
        Object object = this.zzagI;
        synchronized (object) {
            com.google.android.gms.common.internal.zzx.zza(this.zzagS == null, (Object)"Cannot call then() twice.");
            com.google.android.gms.common.internal.zzx.zza(this.zzagM == null, (Object)"Cannot call then() if callbacks are set.");
            this.zzagS = new zzx(this.zzagK);
            TransformedResult<? extends S> transformedResult = this.zzagS.then(transform);
            if (this.isReady()) {
                this.zzagJ.zza(this.zzagS, this.get());
            } else {
                this.zzagM = this.zzagS;
            }
            return transformedResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(R r) {
        Object object = this.zzagI;
        synchronized (object) {
            if (this.zzagO || this.zzL) {
                zzb.zzc(r);
                return;
            }
            com.google.android.gms.common.internal.zzx.zza(!this.isReady(), (Object)"Results have already been set");
            com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed");
            this.zzb(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzx(Status status) {
        Object object = this.zzagI;
        synchronized (object) {
            if (!this.isReady()) {
                this.zza(this.zzc(status));
                this.zzagO = true;
            }
        }
    }

    protected abstract R zzc(Status var1);

    protected void zzpf() {
    }

    @Override
    public Integer zzpa() {
        return this.zzagR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zza(zzq zzq2) {
        Object object = this.zzagI;
        synchronized (object) {
            this.zzagQ = zzq2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R get() {
        R r;
        Object object = this.zzagI;
        synchronized (object) {
            com.google.android.gms.common.internal.zzx.zza(!this.zzagN, (Object)"Result has already been consumed.");
            com.google.android.gms.common.internal.zzx.zza(this.isReady(), (Object)"Result is not ready.");
            r = this.zzagy;
            this.zzagy = null;
            this.zzagM = null;
            this.zzagN = true;
        }
        this.zzpf();
        return r;
    }

    private void zzb(R r) {
        this.zzagy = r;
        this.zzagQ = null;
        this.zzpJ.countDown();
        Status status = this.zzagy.getStatus();
        if (this.zzagM != null) {
            this.zzagJ.zzph();
            if (!this.zzL) {
                this.zzagJ.zza(this.zzagM, (R)this.get());
            }
        }
        for (PendingResult.zza zza2 : this.zzagL) {
            zza2.zzu(status);
        }
        this.zzagL.clear();
    }

    public static void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"BasePendingResult", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    public static class zza<R extends Result>
    extends Handler {
        public zza() {
            this(Looper.getMainLooper());
        }

        public zza(Looper looper) {
            super(looper);
        }

        public void zza(ResultCallback<? super R> resultCallback, R r) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r)));
        }

        public void zza(zzb<R> zzb2, long l) {
            this.sendMessageDelayed(this.obtainMessage(2, zzb2), l);
        }

        public void zzph() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.zzb((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    zzb zzb2 = (zzb)msg.obj;
                    zzb2.zzx(Status.zzagF);
                    return;
                }
            }
            Log.wtf((String)"BasePendingResult", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        protected void zzb(ResultCallback<? super R> resultCallback, R r) {
            try {
                resultCallback.onResult(r);
            }
            catch (RuntimeException runtimeException) {
                zzb.zzc(r);
                throw runtimeException;
            }
        }
    }
}

