/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.ResultCallbacks;
import com.google.android.gms.common.api.ResultTransform;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.TransformedResult;
import com.google.android.gms.common.api.internal.zzs;
import com.google.android.gms.common.api.internal.zzt;
import java.lang.ref.WeakReference;

public class zzx<R extends Result>
extends TransformedResult<R>
implements ResultCallback<R> {
    private ResultTransform<? super R, ? extends Result> zzaiN = null;
    private zzx<? extends Result> zzaiO = null;
    private ResultCallbacks<? super R> zzaiP = null;
    private PendingResult<R> zzaiQ = null;
    private final Object zzagI = new Object();
    private Status zzaiR = null;
    private final WeakReference<GoogleApiClient> zzagK;
    private final zza zzaiS;

    public zzx(WeakReference<GoogleApiClient> weakReference) {
        com.google.android.gms.common.internal.zzx.zzb(weakReference, (Object)"GoogleApiClient reference must not be null");
        this.zzagK = weakReference;
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzagK.get();
        this.zzaiS = new zza(googleApiClient != null ? googleApiClient.getLooper() : Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public <S extends Result> TransformedResult<S> then(@NonNull ResultTransform<? super R, ? extends S> transform) {
        Object object = this.zzagI;
        synchronized (object) {
            com.google.android.gms.common.internal.zzx.zza(this.zzaiN == null, (Object)"Cannot call then() twice.");
            com.google.android.gms.common.internal.zzx.zza(this.zzaiP == null, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaiN = transform;
            zzx<R> zzx2 = new zzx<R>(this.zzagK);
            this.zzaiO = zzx2;
            this.zzpT();
            return zzx2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void andFinally(@NonNull ResultCallbacks<? super R> callbacks) {
        Object object = this.zzagI;
        synchronized (object) {
            com.google.android.gms.common.internal.zzx.zza(this.zzaiP == null, (Object)"Cannot call andFinally() twice.");
            com.google.android.gms.common.internal.zzx.zza(this.zzaiN == null, (Object)"Cannot call then() and andFinally() on the same TransformedResult.");
            this.zzaiP = callbacks;
            this.zzpT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(R result) {
        Object object = this.zzagI;
        synchronized (object) {
            if (result.getStatus().isSuccess()) {
                if (this.zzaiN != null) {
                    zzs.zzpN().submit(new Runnable((Result)result){
                        final /* synthetic */ Result zzaiT;
                        {
                            this.zzaiT = result;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        @WorkerThread
                        public void run() {
                            try {
                                PendingResult pendingResult = zzx.this.zzaiN.onSuccess(this.zzaiT);
                                zzx.this.zzaiS.sendMessage(zzx.this.zzaiS.obtainMessage(0, pendingResult));
                            }
                            catch (RuntimeException runtimeException) {
                                zzx.this.zzaiS.sendMessage(zzx.this.zzaiS.obtainMessage(1, runtimeException));
                            }
                            finally {
                                zzx.this.zzc(this.zzaiT);
                                GoogleApiClient googleApiClient = (GoogleApiClient)zzx.this.zzagK.get();
                                if (googleApiClient != null) {
                                    googleApiClient.zzb(zzx.this);
                                }
                            }
                        }
                    });
                } else if (this.zzpV()) {
                    this.zzaiP.onSuccess(result);
                }
            } else {
                this.zzy(result.getStatus());
                this.zzc((Result)result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zza(PendingResult<?> pendingResult) {
        Object object = this.zzagI;
        synchronized (object) {
            this.zzaiQ = pendingResult;
            this.zzpT();
        }
    }

    private void zzpT() {
        if (this.zzaiN == null && this.zzaiP == null) {
            return;
        }
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzagK.get();
        if (this.zzaiN != null && googleApiClient != null) {
            googleApiClient.zza(this);
        }
        if (this.zzaiR != null) {
            this.zzz(this.zzaiR);
        } else if (this.zzaiQ != null) {
            this.zzaiQ.setResultCallback(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzy(Status status) {
        Object object = this.zzagI;
        synchronized (object) {
            this.zzaiR = status;
            this.zzz(this.zzaiR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzz(Status status) {
        Object object = this.zzagI;
        synchronized (object) {
            if (this.zzaiN != null) {
                Status status2 = this.zzaiN.onFailure(status);
                com.google.android.gms.common.internal.zzx.zzb(status2, (Object)"onFailure must not return null");
                super.zzy(status2);
            } else if (this.zzpV()) {
                this.zzaiP.onFailure(status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzpU() {
        Object object = this.zzagI;
        synchronized (object) {
            this.zzaiP = null;
        }
    }

    private boolean zzpV() {
        GoogleApiClient googleApiClient = (GoogleApiClient)this.zzagK.get();
        return this.zzaiP != null && googleApiClient != null;
    }

    private void zzc(Result result) {
        if (result instanceof Releasable) {
            try {
                ((Releasable)((Object)result)).release();
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)"TransformedResultImpl", (String)("Unable to release " + result), (Throwable)runtimeException);
            }
        }
    }

    private final class zza
    extends Handler {
        public zza(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    PendingResult pendingResult = (PendingResult)msg.obj;
                    Object object = zzx.this.zzagI;
                    synchronized (object) {
                        if (pendingResult == null) {
                            ((zzx)zzx.this.zzaiO).zzy(new Status(13, "Transform returned null"));
                        } else if (pendingResult instanceof zzt) {
                            ((zzx)zzx.this.zzaiO).zzy(((zzt)pendingResult).getStatus());
                        } else {
                            zzx.this.zzaiO.zza(pendingResult);
                        }
                        break;
                    }
                }
                case 1: {
                    RuntimeException runtimeException = (RuntimeException)msg.obj;
                    Log.e((String)"TransformedResultImpl", (String)("Runtime exception on the transformation worker thread: " + runtimeException.getMessage()));
                    throw runtimeException;
                }
                default: {
                    Log.e((String)"TransformedResultImpl", (String)("TransformationResultHandler received unknown message type: " + msg.what));
                }
            }
        }
    }
}

