/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzr;
import com.google.android.gms.common.internal.zzs;
import com.google.android.gms.common.internal.zzx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class zzj<T extends IInterface>
implements Api.zzb,
zzk.zza {
    private int zzals;
    private long zzalt;
    private long zzalu;
    private int zzalv;
    private long zzalw;
    private final Context mContext;
    private final com.google.android.gms.common.internal.zzf zzahz;
    private final Looper zzagr;
    private final zzl zzalx;
    private final com.google.android.gms.common.zzc zzags;
    final Handler mHandler;
    private final Object zzpV = new Object();
    private final Object zzaly = new Object();
    private zzs zzalz;
    private GoogleApiClient.zza zzalA = new zzf();
    private T zzalB;
    private final ArrayList<zzc<?>> zzalC = new ArrayList();
    private zze zzalD;
    private int zzalE = 1;
    private final Set<Scope> zzXf;
    private final Account zzTI;
    private final GoogleApiClient.ConnectionCallbacks zzalF;
    private final GoogleApiClient.OnConnectionFailedListener zzalG;
    private final int zzalH;
    protected AtomicInteger zzalI = new AtomicInteger(0);
    public static final String[] zzalJ = new String[]{"service_esmobile", "service_googleme"};

    protected zzj(Context context, Looper looper, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this(context, looper, zzl.zzau(context), com.google.android.gms.common.zzc.zzoK(), n, zzf2, zzx.zzz(connectionCallbacks), zzx.zzz(onConnectionFailedListener));
    }

    protected zzj(Context context, Looper looper, zzl zzl2, com.google.android.gms.common.zzc zzc2, int n, com.google.android.gms.common.internal.zzf zzf2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = zzx.zzb(context, (Object)"Context must not be null");
        this.zzagr = zzx.zzb(looper, (Object)"Looper must not be null");
        this.zzalx = zzx.zzb(zzl2, (Object)"Supervisor must not be null");
        this.zzags = zzx.zzb(zzc2, (Object)"API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzalH = n;
        this.zzahz = zzx.zzz(zzf2);
        this.zzTI = zzf2.getAccount();
        this.zzXf = this.zza(zzf2.zzqt());
        this.zzalF = connectionCallbacks;
        this.zzalG = onConnectionFailedListener;
    }

    private Set<Scope> zza(Set<Scope> set) {
        Set<Scope> set2 = this.zzb(set);
        if (set2 == null) {
            return set2;
        }
        for (Scope scope : set2) {
            if (set.contains(scope)) continue;
            throw new IllegalStateException("Expanding scopes is not permitted, use implied scopes instead");
        }
        return set2;
    }

    @NonNull
    protected Set<Scope> zzb(@NonNull Set<Scope> set) {
        return set;
    }

    @NonNull
    protected abstract String zzgu();

    @NonNull
    protected abstract String zzgv();

    @Nullable
    protected final String zzqD() {
        return this.zzahz.zzqw();
    }

    @Nullable
    protected abstract T zzW(IBinder var1);

    @CallSuper
    protected void zza(@NonNull T t) {
        this.zzalu = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionSuspended(int cause) {
        this.zzals = cause;
        this.zzalt = System.currentTimeMillis();
    }

    @CallSuper
    protected void onConnectionFailed(ConnectionResult result) {
        this.zzalv = result.getErrorCode();
        this.zzalw = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(int n, T t) {
        zzx.zzac(n == 3 == (t != null));
        Object object = this.zzpV;
        synchronized (object) {
            this.zzalE = n;
            this.zzalB = t;
            this.zzc(n, t);
            switch (n) {
                case 2: {
                    this.zzqE();
                    break;
                }
                case 3: {
                    this.zza(t);
                    break;
                }
                case 1: {
                    this.zzqF();
                }
            }
        }
    }

    void zzc(int n, T t) {
    }

    private void zzqE() {
        if (this.zzalD != null) {
            Log.e((String)"GmsClient", (String)("Calling connect() while still connected, missing disconnect() for " + this.zzgu()));
            this.zzalx.zzb(this.zzgu(), (ServiceConnection)this.zzalD, this.zzqD());
            this.zzalI.incrementAndGet();
        }
        this.zzalD = new zze(this.zzalI.get());
        boolean bl = this.zzalx.zza(this.zzgu(), (ServiceConnection)this.zzalD, this.zzqD());
        if (!bl) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.zzgu()));
            this.zzm(8, this.zzalI.get());
        }
    }

    private void zzqF() {
        if (this.zzalD != null) {
            this.zzalx.zzb(this.zzgu(), (ServiceConnection)this.zzalD, this.zzqD());
            this.zzalD = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(int n, int n2, T t) {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzalE != n) {
                return false;
            }
            this.zzb(n2, t);
            return true;
        }
    }

    public void zzqG() {
        int n = this.zzags.isGooglePlayServicesAvailable(this.mContext);
        if (n != 0) {
            this.zzb(1, null);
            this.zzalA = new zzf();
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzalI.get(), n));
            return;
        }
        this.zza(new zzf());
    }

    @Override
    public void zza(@NonNull GoogleApiClient.zza zza2) {
        this.zzalA = zzx.zzb(zza2, (Object)"Connection progress callbacks cannot be null.");
        this.zzb(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzalE == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.zzpV;
        synchronized (object) {
            return this.zzalE == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.zzalI.incrementAndGet();
        Object object = this.zzalC;
        synchronized (object) {
            int n = this.zzalC.size();
            for (int i = 0; i < n; ++i) {
                this.zzalC.get(i).zzqO();
            }
            this.zzalC.clear();
        }
        object = this.zzaly;
        synchronized (object) {
            this.zzalz = null;
        }
        this.zzb(1, null);
    }

    public void zzbS(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(4, this.zzalI.get(), n));
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final Looper getLooper() {
        return this.zzagr;
    }

    public final Account zzqq() {
        return this.zzTI != null ? this.zzTI : new Account("<<default account>>", "com.google");
    }

    protected final com.google.android.gms.common.internal.zzf zzqH() {
        return this.zzahz;
    }

    protected Bundle zzml() {
        return new Bundle();
    }

    @BinderThread
    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzg(n, iBinder, bundle)));
    }

    protected void zzm(int n, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, n2, -1, (Object)new zzh(n)));
    }

    protected final void zzqI() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @Override
    public Bundle zzoi() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T zzqJ() throws DeadObjectException {
        Object object = this.zzpV;
        synchronized (object) {
            if (this.zzalE == 4) {
                throw new DeadObjectException();
            }
            this.zzqI();
            zzx.zza(this.zzalB != null, (Object)"Client is connected but service is null");
            return this.zzalB;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    public void zza(zzp zzp2, Set<Scope> set) {
        try {
            Bundle bundle = this.zzml();
            GetServiceRequest getServiceRequest = new GetServiceRequest(this.zzalH).zzcG(this.mContext.getPackageName()).zzj(bundle);
            if (set != null) {
                getServiceRequest.zzd(set);
            }
            if (this.zzmE()) {
                getServiceRequest.zzc(this.zzqq()).zzb(zzp2);
            } else if (this.zzqK()) {
                getServiceRequest.zzc(this.zzTI);
            }
            Object object = this.zzaly;
            synchronized (object) {
                if (this.zzalz != null) {
                    this.zzalz.zza((zzr)new zzd(this, this.zzalI.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"service died");
            this.zzbS(1);
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"Remote exception occurred", (Throwable)remoteException);
        }
    }

    @Override
    public boolean zzmE() {
        return false;
    }

    public boolean zzqK() {
        return false;
    }

    @Override
    public boolean zznb() {
        return false;
    }

    @Override
    public Intent zznc() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        T t;
        int n;
        Object object = this.zzpV;
        synchronized (object) {
            n = this.zzalE;
            t = this.zzalB;
        }
        writer.append(prefix).append("mConnectState=");
        switch (n) {
            case 2: {
                writer.print("CONNECTING");
                break;
            }
            case 3: {
                writer.print("CONNECTED");
                break;
            }
            case 4: {
                writer.print("DISCONNECTING");
                break;
            }
            case 1: {
                writer.print("DISCONNECTED");
                break;
            }
            default: {
                writer.print("UNKNOWN");
            }
        }
        writer.append(" mService=");
        if (t == null) {
            writer.println("null");
        } else {
            writer.append(this.zzgv()).append("@").println(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzalu > 0L) {
            writer.append(prefix).append("lastConnectedTime=").println(this.zzalu + " " + ((DateFormat)object).format(new Date(this.zzalu)));
        }
        if (this.zzalt > 0L) {
            writer.append(prefix).append("lastSuspendedCause=");
            switch (this.zzals) {
                case 1: {
                    writer.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    writer.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    writer.append(String.valueOf(this.zzals));
                }
            }
            writer.append(" lastSuspendedTime=").println(this.zzalt + " " + ((DateFormat)object).format(new Date(this.zzalt)));
        }
        if (this.zzalw > 0L) {
            writer.append(prefix).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzalv));
            writer.append(" lastFailedTime=").println(this.zzalw + " " + ((DateFormat)object).format(new Date(this.zzalw)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IBinder zzoT() {
        Object object = this.zzaly;
        synchronized (object) {
            if (this.zzalz == null) {
                return null;
            }
            return this.zzalz.asBinder();
        }
    }

    public static final class zzd
    extends zzr.zza {
        private zzj zzalN;
        private final int zzalO;

        public zzd(@NonNull zzj zzj2, int n) {
            this.zzalN = zzj2;
            this.zzalO = n;
        }

        @Override
        @BinderThread
        public void zzb(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public void zza(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            zzx.zzb(this.zzalN, (Object)"onPostInitComplete can be called only once per call to getRemoteService");
            this.zzalN.zza(n, iBinder, bundle, this.zzalO);
            this.zzqP();
        }

        private void zzqP() {
            this.zzalN = null;
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        public final int statusCode;
        public final Bundle zzalK;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzalK = bundle;
        }

        protected abstract boolean zzqL();

        protected abstract void zzj(ConnectionResult var1);

        protected void zzc(Boolean bl) {
            if (bl == null) {
                zzj.this.zzb(1, null);
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    if (this.zzqL()) break;
                    zzj.this.zzb(1, null);
                    this.zzj(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    zzj.this.zzb(1, null);
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    zzj.this.zzb(1, null);
                    PendingIntent pendingIntent = null;
                    if (this.zzalK != null) {
                        pendingIntent = (PendingIntent)this.zzalK.getParcelable("pendingIntent");
                    }
                    this.zzj(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void zzqM() {
        }

        @Override
        protected /* synthetic */ void zzw(Object object) {
            this.zzc((Boolean)object);
        }
    }

    protected final class zzg
    extends zza {
        public final IBinder zzalP;

        @BinderThread
        public zzg(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzalP = iBinder;
        }

        @Override
        protected void zzj(ConnectionResult connectionResult) {
            if (zzj.this.zzalG != null) {
                zzj.this.zzalG.onConnectionFailed(connectionResult);
            }
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzqL() {
            String string2;
            try {
                string2 = this.zzalP.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!zzj.this.zzgv().equals(string2)) {
                Log.e((String)"GmsClient", (String)("service descriptor mismatch: " + zzj.this.zzgv() + " vs. " + string2));
                return false;
            }
            Object t = zzj.this.zzW(this.zzalP);
            if (t != null && zzj.this.zza(2, 3, t)) {
                Bundle bundle = zzj.this.zzoi();
                if (zzj.this.zzalF != null) {
                    zzj.this.zzalF.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzh
    extends zza {
        @BinderThread
        public zzh(int n) {
            super(n, null);
        }

        @Override
        protected void zzj(ConnectionResult connectionResult) {
            zzj.this.zzalA.zza(connectionResult);
            zzj.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected boolean zzqL() {
            zzj.this.zzalA.zza(ConnectionResult.zzafB);
            return true;
        }
    }

    protected class zzf
    implements GoogleApiClient.zza {
        @Override
        public void zza(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                zzj.this.zza(null, zzj.this.zzXf);
            } else if (zzj.this.zzalG != null) {
                zzj.this.zzalG.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzc<TListener> {
        private TListener mListener;
        private boolean zzalM;

        public zzc(TListener TListener) {
            this.mListener = TListener;
            this.zzalM = false;
        }

        protected abstract void zzw(TListener var1);

        protected abstract void zzqM();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzqN() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.mListener;
                if (this.zzalM) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.zzw(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzqM();
                    throw runtimeException;
                }
            } else {
                this.zzqM();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzalM = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.zzqO();
            ArrayList arrayList = zzj.this.zzalC;
            synchronized (arrayList) {
                zzj.this.zzalC.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void zzqO() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.mListener = null;
            }
        }
    }

    final class zzb
    extends Handler {
        public zzb(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            if (zzj.this.zzalI.get() != msg.arg1) {
                if (this.zzb(msg)) {
                    this.zza(msg);
                }
                return;
            }
            if (!(msg.what != 1 && msg.what != 5 || zzj.this.isConnecting())) {
                this.zza(msg);
                return;
            }
            if (msg.what == 3) {
                ConnectionResult connectionResult = new ConnectionResult(msg.arg2, null);
                zzj.this.zzalA.zza(connectionResult);
                zzj.this.onConnectionFailed(connectionResult);
                return;
            }
            if (msg.what == 4) {
                zzj.this.zzb(4, null);
                if (zzj.this.zzalF != null) {
                    zzj.this.zzalF.onConnectionSuspended(msg.arg2);
                }
                zzj.this.onConnectionSuspended(msg.arg2);
                zzj.this.zza(4, 1, null);
                return;
            }
            if (msg.what == 2 && !zzj.this.isConnected()) {
                this.zza(msg);
                return;
            }
            if (this.zzb(msg)) {
                zzc zzc2 = (zzc)msg.obj;
                zzc2.zzqN();
                return;
            }
            Log.wtf((String)"GmsClient", (String)("Don't know how to handle message: " + msg.what), (Throwable)new Exception());
        }

        private void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzqM();
            zzc2.unregister();
        }

        private boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 5;
        }
    }

    public final class zze
    implements ServiceConnection {
        private final int zzalO;

        public zze(int n) {
            this.zzalO = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName component, IBinder binder) {
            zzx.zzb(binder, (Object)"Expecting a valid IBinder");
            Object object = zzj.this.zzaly;
            synchronized (object) {
                zzj.this.zzalz = zzs.zza.zzaS(binder);
            }
            zzj.this.zzm(0, this.zzalO);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceDisconnected(ComponentName component) {
            Object object = zzj.this.zzaly;
            synchronized (object) {
                zzj.this.zzalz = null;
            }
            zzj.this.mHandler.sendMessage(zzj.this.mHandler.obtainMessage(4, this.zzalO, 1));
        }
    }
}

